/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common;

import com.sap.sse.common.Util;
import java.io.Serializable;
import java.util.ArrayList;

public interface RepeatablePart
extends Serializable {
    public int getZeroBasedIndexOfRepeatablePartStart();

    public int getZeroBasedIndexOfRepeatablePartEnd();

    default public int length() {
        return this.getZeroBasedIndexOfRepeatablePartEnd() - this.getZeroBasedIndexOfRepeatablePartStart();
    }

    default public <T> Iterable<T> createSequence(int repetitions, Iterable<T> sequenceWithRepeatablePart) {
        this.validateRepeatablePartForSequence(sequenceWithRepeatablePart);
        int zeroBasedIndexOfRepeatablePartStart = this.getZeroBasedIndexOfRepeatablePartStart();
        int zeroBasedIndexOfRepeatablePartEnd = this.getZeroBasedIndexOfRepeatablePartEnd();
        ArrayList sequenceWithRepeatablePartAsList = new ArrayList();
        Util.addAll(sequenceWithRepeatablePart, sequenceWithRepeatablePartAsList);
        int sequenceLength = sequenceWithRepeatablePartAsList.size();
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < zeroBasedIndexOfRepeatablePartStart) {
            result.add(sequenceWithRepeatablePartAsList.get(i));
            ++i;
        }
        int lap = 1;
        while (lap < repetitions) {
            int i2 = zeroBasedIndexOfRepeatablePartStart;
            while (i2 < zeroBasedIndexOfRepeatablePartEnd) {
                result.add(sequenceWithRepeatablePartAsList.get(i2));
                ++i2;
            }
            ++lap;
        }
        i = zeroBasedIndexOfRepeatablePartEnd;
        while (i < sequenceLength) {
            result.add(sequenceWithRepeatablePartAsList.get(i));
            ++i;
        }
        return result;
    }

    default public <T> void validateRepeatablePartForSequence(Iterable<T> sequenceWithRepeatablePart) {
        int zeroBasedIndexOfRepeatablePartEnd = this.getZeroBasedIndexOfRepeatablePartEnd();
        int sequenceLength = Util.size(sequenceWithRepeatablePart);
        if (sequenceLength < zeroBasedIndexOfRepeatablePartEnd) {
            throw new IllegalArgumentException("Repeatable part (" + this.getZeroBasedIndexOfRepeatablePartStart() + ", " + zeroBasedIndexOfRepeatablePartEnd + ") is out of range for sequence of length " + sequenceLength);
        }
    }
}

