/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.racegroup.impl;

import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.racegroup.RaceCell;
import com.sap.sailing.domain.base.racegroup.RaceRow;
import com.sap.sailing.domain.base.racegroup.impl.RaceRowImpl;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class RaceRowDeserializer
implements JsonDeserializer<RaceRow> {
    private JsonDeserializer<Fleet> fleetDeserializer;
    private JsonDeserializer<RaceCell> raceCellDeserializer;

    public RaceRowDeserializer(JsonDeserializer<Fleet> fleetDeserializer, JsonDeserializer<RaceCell> raceCellDeserializer) {
        this.fleetDeserializer = fleetDeserializer;
        this.raceCellDeserializer = raceCellDeserializer;
    }

    public RaceRow deserialize(JSONObject object) throws JsonDeserializationException {
        JSONObject fleetObject = Helpers.toJSONObjectSafe(object.get((Object)"fleet"));
        JSONArray cellsObject = Helpers.getNestedArraySafe(object, "races");
        ArrayList<RaceCell> races = new ArrayList<RaceCell>();
        Fleet fleet = (Fleet)this.fleetDeserializer.deserialize(fleetObject);
        for (Object cellObject : cellsObject) {
            JSONObject cellJson = Helpers.toJSONObjectSafe(cellObject);
            races.add((RaceCell)this.raceCellDeserializer.deserialize(cellJson));
        }
        return new RaceRowImpl(fleet, races);
    }
}

