/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.coursedata.impl;

import com.sap.sailing.domain.base.ControlPointWithTwoMarks;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.server.gateway.deserialization.coursedata.impl.MarkDeserializer;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import org.json.simple.JSONObject;

public class GateDeserializer
implements JsonDeserializer<ControlPointWithTwoMarks> {
    private SharedDomainFactory<?> factory;
    private final MarkDeserializer markDeserializer;

    public GateDeserializer(SharedDomainFactory<?> factory, MarkDeserializer markDeserializer) {
        this.factory = factory;
        this.markDeserializer = markDeserializer;
    }

    public ControlPointWithTwoMarks deserialize(JSONObject object) throws JsonDeserializationException {
        JSONObject jsonLeftMark = (JSONObject)object.get((Object)"left");
        JSONObject jsonRightMark = (JSONObject)object.get((Object)"right");
        Mark leftMark = this.markDeserializer.deserialize(jsonLeftMark);
        Mark rightMark = this.markDeserializer.deserialize(jsonRightMark);
        String gateName = (String)object.get((Object)"name");
        String gateShortName = (String)object.get((Object)"shortName");
        ControlPointWithTwoMarks controlPoint = this.factory.createControlPointWithTwoMarks(leftMark, rightMark, gateName, gateShortName);
        return controlPoint;
    }
}

