/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.kiworesultimport.impl;

import com.sap.sailing.kiworesultimport.Boat;
import com.sap.sailing.kiworesultimport.BoatResultInRace;
import com.sap.sailing.kiworesultimport.ResultList;
import com.sap.sailing.kiworesultimport.impl.AbstractNodeWrapper;
import com.sap.sailing.kiworesultimport.impl.BoatImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResultListImpl
extends AbstractNodeWrapper
implements ResultList {
    private static final Logger logger = Logger.getLogger(ResultListImpl.class.getName());
    private final String sourceName;
    private static final SimpleDateFormat df = new SimpleDateFormat("dd. MMM yyyy HH:mm", Locale.GERMAN);

    public ResultListImpl(Node node, String sourceName) {
        super(node);
        this.sourceName = sourceName;
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public String getLegend() {
        return this.getNode().getAttributes().getNamedItem("legende").getNodeValue();
    }

    @Override
    public String getImagePath() {
        return this.getNode().getAttributes().getNamedItem("imagePfad").getNodeValue();
    }

    @Override
    public String getStatus() {
        return this.getNode().getAttributes().getNamedItem("status").getNodeValue();
    }

    @Override
    public String getBoatClassName() {
        return this.getNode().getAttributes().getNamedItem("class").getNodeValue();
    }

    @Override
    public String getEvent() {
        return this.getNode().getAttributes().getNamedItem("event").getNodeValue();
    }

    @Override
    public String getTime() {
        return this.getNode().getAttributes().getNamedItem("time").getNodeValue();
    }

    @Override
    public String getDate() {
        return this.getNode().getAttributes().getNamedItem("date").getNodeValue();
    }

    @Override
    public TimePoint getTimePointPublished() {
        MillisecondsTimePoint result = null;
        String dateTime = String.valueOf(this.getDate()) + " " + this.getTime();
        try {
            Date d = df.parse(dateTime);
            result = new MillisecondsTimePoint(d);
        }
        catch (ParseException e) {
            logger.info("Failed to parse result list date/time " + dateTime);
        }
        return result;
    }

    @Override
    public Iterable<Boat> getBoats() {
        ArrayList<Boat> result = new ArrayList<Boat>();
        NodeList verteilung = ((Element)this.getNode()).getElementsByTagName("Verteilung");
        int i = 0;
        while (i < verteilung.getLength()) {
            NodeList boats = ((Element)verteilung.item(i)).getElementsByTagName("Boat");
            int j = 0;
            while (j < boats.getLength()) {
                result.add(new BoatImpl(boats.item(j)));
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    public Boat getBoatBySailID(String sailID) {
        for (Boat boat : this.getBoats()) {
            if (!sailID.equals(boat.getSailingNumber())) continue;
            return boat;
        }
        return null;
    }

    @Override
    public Iterable<Integer> getRaceNumbers() {
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Boat boat : this.getBoats()) {
            for (BoatResultInRace results : boat.getResultsInRaces()) {
                result.add(results.getRaceNumber());
            }
        }
        return result;
    }
}

