/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.kiworesultimport.impl;

import com.sap.sailing.kiworesultimport.Boat;
import com.sap.sailing.kiworesultimport.BoatResultInRace;
import com.sap.sailing.kiworesultimport.Crew;
import com.sap.sailing.kiworesultimport.impl.BoatResultsInRaceImpl;
import com.sap.sailing.kiworesultimport.impl.CrewImpl;
import com.sap.sailing.kiworesultimport.impl.NamedImpl;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BoatImpl
extends NamedImpl
implements Boat {
    public BoatImpl(Node node) {
        super(node);
    }

    @Override
    public String getSailingNumber() {
        return this.getNode().getAttributes().getNamedItem("sailingnumber").getNodeValue();
    }

    @Override
    public Integer getRank() {
        return Integer.valueOf(this.getNode().getAttributes().getNamedItem("position").getNodeValue());
    }

    @Override
    public String getPrice() {
        return this.getNode().getAttributes().getNamedItem("preis").getNodeValue();
    }

    @Override
    public Crew getCrew() {
        NodeList crew = ((Element)this.getNode()).getElementsByTagName("Crew");
        return new CrewImpl(crew.item(0));
    }

    @Override
    public Double getTotalPoints() {
        return Double.valueOf(((Element)this.getNode()).getElementsByTagName("Races").item(0).getAttributes().getNamedItem("totalpoints").getNodeValue().replace(',', '.'));
    }

    @Override
    public Iterable<BoatResultInRace> getResultsInRaces() {
        ArrayList<BoatResultInRace> result = new ArrayList<BoatResultInRace>();
        NodeList races = ((Element)((Element)this.getNode()).getElementsByTagName("Races").item(0)).getElementsByTagName("Race");
        int i = 0;
        while (i < races.getLength()) {
            result.add(new BoatResultsInRaceImpl(races.item(i)));
            ++i;
        }
        return result;
    }

    @Override
    public BoatResultInRace getResultsInRace(int raceNumberOneBased) {
        for (BoatResultInRace race : this.getResultsInRaces()) {
            if (race.getRaceNumber() != raceNumberOneBased) continue;
            return race;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getSailingNumber();
    }
}

