/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.racelogtracking.impl;

import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceMappingEvent;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.racelogtracking.DeviceMapping;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.WithID;
import com.sap.sse.common.impl.TimeRangeImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DeviceMappingImpl<ItemType extends WithID>
implements DeviceMapping<ItemType> {
    private static final long serialVersionUID = -4602948402371623654L;
    private final ItemType mappedTo;
    private final DeviceIdentifier device;
    private final TimeRange timeRange;
    private final List<Serializable> originalRaceLogEventIds = new ArrayList<Serializable>();
    private final Class<?> eventType;

    public DeviceMappingImpl(ItemType mappedTo, DeviceIdentifier device, TimeRange timeRange, Class<?> eventType) {
        this.mappedTo = mappedTo;
        this.device = device;
        this.timeRange = timeRange;
        this.eventType = eventType;
    }

    public DeviceMappingImpl(ItemType mappedTo, DeviceIdentifier device, TimeRange timeRange, Serializable originalRaceLogEventId, Class<?> eventType) {
        this(mappedTo, device, timeRange, eventType);
        if (originalRaceLogEventId != null) {
            this.originalRaceLogEventIds.add(originalRaceLogEventId);
        }
    }

    public DeviceMappingImpl(ItemType mappedTo, DeviceIdentifier device, TimeRange timeRange, List<? extends Serializable> originalRaceLogEventIds, Class<?> eventType) {
        this(mappedTo, device, timeRange, eventType);
        if (originalRaceLogEventIds != null) {
            this.originalRaceLogEventIds.addAll(originalRaceLogEventIds);
        }
    }

    @Override
    public DeviceIdentifier getDevice() {
        return this.device;
    }

    @Override
    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    @Override
    public ItemType getMappedTo() {
        return this.mappedTo;
    }

    public TimePoint getTimePoint() {
        return this.timeRange.from();
    }

    @Override
    public Class<?> getEventType() {
        return this.eventType;
    }

    public static <T extends WithID> DeviceMapping<T> convertToDeviceMapping(RegattaLogDeviceMappingEvent<T> event) {
        return new DeviceMappingImpl<T>(event.getMappedTo(), event.getDevice(), (TimeRange)new TimeRangeImpl(event.getFrom(), event.getToInclusive(), true), event.getId(), event.getClass());
    }

    public String toString() {
        return "Device Mapping - device: " + this.device + ", mapped to: " + this.mappedTo + ", time range: " + this.timeRange;
    }

    @Override
    public List<Serializable> getOriginalRaceLogEventIds() {
        return this.originalRaceLogEventIds;
    }
}

