/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.coursetemplate.impl;

import com.sap.sailing.domain.coursetemplate.CourseTemplate;
import com.sap.sailing.domain.coursetemplate.MarkRole;
import com.sap.sailing.domain.coursetemplate.MarkTemplate;
import com.sap.sailing.domain.coursetemplate.WaypointTemplate;
import com.sap.sse.common.RepeatablePart;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.NamedWithUUIDImpl;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class CourseTemplateImpl
extends NamedWithUUIDImpl
implements CourseTemplate {
    private static final long serialVersionUID = -183875832585632806L;
    private final String shortName;
    private final Set<MarkTemplate> marks;
    private final ArrayList<WaypointTemplate> waypoints;
    private final Map<MarkTemplate, MarkRole> defaultMarkRolesForMarkTemplates;
    private final Map<MarkRole, MarkTemplate> defaultMarkTemplatesForMarkRoles;
    private Iterable<String> tags = new ArrayList<String>();
    private final URL optionalImageURL;
    private final RepeatablePart optionalRepeatablePart;
    private final Integer defaultNumberOfLaps;

    public CourseTemplateImpl(String name, String shortName, Iterable<MarkTemplate> marks, Iterable<WaypointTemplate> waypoints, Map<MarkRole, MarkTemplate> defaultMarkTemplatesForMarkRoles, Map<MarkTemplate, MarkRole> defaultMarkRolesForMarkTemplates, URL optionalImageURL) {
        this(UUID.randomUUID(), name, shortName, marks, waypoints, defaultMarkTemplatesForMarkRoles, defaultMarkRolesForMarkTemplates, optionalImageURL);
    }

    public CourseTemplateImpl(UUID id, String name, String shortName, Iterable<MarkTemplate> marks, Iterable<WaypointTemplate> waypoints, Map<MarkRole, MarkTemplate> defaultMarkTemplatesForMarkRoles, Map<MarkTemplate, MarkRole> defaultMarkRolesForMarkTemplates, URL optionalImageURL) {
        this(id, name, shortName, marks, waypoints, defaultMarkTemplatesForMarkRoles, defaultMarkRolesForMarkTemplates, optionalImageURL, null, null);
    }

    public CourseTemplateImpl(UUID id, String name, String shortName, Iterable<MarkTemplate> marks, Iterable<WaypointTemplate> waypoints, Map<MarkRole, MarkTemplate> defaultMarkTemplatesForMarkRoles, Map<MarkTemplate, MarkRole> defaultMarkRolesForMarkTemplates, URL optionalImageURL, RepeatablePart optionalRepeatablePart, Integer defaultNumberOfLaps) {
        super(name, id);
        this.shortName = shortName;
        this.defaultNumberOfLaps = defaultNumberOfLaps;
        if (optionalRepeatablePart != null) {
            optionalRepeatablePart.validateRepeatablePartForSequence(waypoints);
        }
        this.waypoints = new ArrayList();
        Util.addAll(waypoints, this.waypoints);
        this.marks = new HashSet<MarkTemplate>();
        Util.addAll(marks, this.marks);
        this.optionalImageURL = optionalImageURL;
        this.optionalRepeatablePart = optionalRepeatablePart;
        this.defaultMarkRolesForMarkTemplates = new HashMap<MarkTemplate, MarkRole>(defaultMarkRolesForMarkTemplates);
        this.defaultMarkTemplatesForMarkRoles = new HashMap<MarkRole, MarkTemplate>(defaultMarkTemplatesForMarkRoles);
        for (Map.Entry<MarkRole, MarkTemplate> e : defaultMarkTemplatesForMarkRoles.entrySet()) {
            MarkRole previousDefaultMarkRole = this.defaultMarkRolesForMarkTemplates.put(e.getValue(), e.getKey());
            if (previousDefaultMarkRole == null || previousDefaultMarkRole == e.getKey()) continue;
            throw new IllegalArgumentException("Inconsistent default mark role assignment: mark template " + e.getValue() + " was assigned to mark role " + previousDefaultMarkRole + " but now shall default to mark role " + e.getKey());
        }
        this.validateWaypointsAgainstRolesAndMappingSymmetry();
    }

    private void validateWaypointsAgainstRolesAndMappingSymmetry() {
        for (WaypointTemplate waypoint : this.waypoints) {
            for (MarkRole markRole : waypoint.getControlPointTemplate().getMarkRoles()) {
                if (!this.defaultMarkTemplatesForMarkRoles.containsKey(markRole)) {
                    throw new IllegalArgumentException("Mark role " + markRole + " used by waypoint template " + waypoint + " in course template " + this + " is not providing a default mark template");
                }
                if (!Util.contains(this.marks, (Object)this.defaultMarkTemplatesForMarkRoles.get(markRole))) {
                    throw new IllegalArgumentException("Mark template " + this.defaultMarkTemplatesForMarkRoles.get(markRole) + " used by role " + markRole + " used by waypoint template " + waypoint + " in course template " + this + " is not provided in the collection of marks");
                }
                if (Util.equalsWithNull((Object)this.defaultMarkRolesForMarkTemplates.get(this.defaultMarkTemplatesForMarkRoles.get(markRole)), (Object)markRole)) continue;
                throw new IllegalArgumentException("Mark template " + this.defaultMarkTemplatesForMarkRoles.get(markRole) + " used as default for mark role " + markRole + " does not use that same mark role as its default but instead refers to " + this.defaultMarkRolesForMarkTemplates.get(this.defaultMarkTemplatesForMarkRoles.get(markRole)) + " as its default role");
            }
        }
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public MarkTemplate getDefaultMarkTemplateForMarkRole(MarkRole markRole) {
        return this.defaultMarkTemplatesForMarkRoles.get(markRole);
    }

    @Override
    public Map<MarkRole, MarkTemplate> getDefaultMarkTemplatesForMarkRoles() {
        return this.defaultMarkTemplatesForMarkRoles;
    }

    @Override
    public Iterable<MarkTemplate> getMarkTemplates() {
        return this.marks;
    }

    @Override
    public MarkTemplate getMarkTemplateByIdIfContainedInCourseTemplate(UUID markTemplateId) {
        MarkTemplate result = null;
        for (MarkTemplate markTemplate : this.marks) {
            if (!markTemplate.getId().equals(markTemplateId)) continue;
            result = markTemplate;
            break;
        }
        return result;
    }

    @Override
    public Iterable<WaypointTemplate> getWaypointTemplates() {
        return this.waypoints;
    }

    @Override
    public Iterable<WaypointTemplate> getWaypointTemplates(int numberOfLaps) {
        Iterable<WaypointTemplate> result;
        if (this.hasRepeatablePart()) {
            if (numberOfLaps < 1) {
                throw new IllegalArgumentException("The course template " + this + " has a repeatable part, hence the number of laps needs to be at least 1.");
            }
            result = this.optionalRepeatablePart.createSequence(numberOfLaps, this.waypoints);
        } else {
            result = this.waypoints;
        }
        return result;
    }

    public RepeatablePart getRepeatablePart() {
        return this.optionalRepeatablePart;
    }

    @Override
    public Map<MarkTemplate, MarkRole> getDefaultMarkRolesForMarkTemplates() {
        return this.defaultMarkRolesForMarkTemplates;
    }

    @Override
    public MarkRole getOptionalAssociatedRole(MarkTemplate markTemplate) {
        return this.defaultMarkRolesForMarkTemplates.get(markTemplate);
    }

    @Override
    public MarkRole getMarkRoleByIdIfContainedInCourseTemplate(UUID markRoleId) {
        MarkRole result = null;
        for (MarkRole markRole : this.defaultMarkRolesForMarkTemplates.values()) {
            if (!markRole.getId().equals(markRoleId)) continue;
            result = markRole;
            break;
        }
        return result;
    }

    public void setAssociatedRoles(Map<MarkTemplate, MarkRole> associatedRoles) {
        this.defaultMarkRolesForMarkTemplates.clear();
        this.defaultMarkRolesForMarkTemplates.putAll(associatedRoles);
    }

    @Override
    public URL getOptionalImageURL() {
        return this.optionalImageURL;
    }

    @Override
    public Iterable<String> getTags() {
        return this.tags;
    }

    public void setTags(Iterable<String> tags) {
        this.tags = tags;
    }

    @Override
    public Integer getDefaultNumberOfLaps() {
        return this.defaultNumberOfLaps;
    }
}

