/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base;

import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sse.common.Named;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public interface CourseBase
extends Named {
    public List<Leg> getLegs();

    public Iterable<Waypoint> getWaypoints();

    public Waypoint getWaypointForControlPoint(ControlPoint var1, int var2);

    public int getIndexOfWaypoint(Waypoint var1);

    public Waypoint getFirstWaypoint();

    public Waypoint getLastWaypoint();

    public void addWaypoint(int var1, Waypoint var2);

    public void removeWaypoint(int var1);

    public Leg getFirstLeg();

    public UUID getOriginatingCourseTemplateIdOrNull();

    public Map<Mark, UUID> getAssociatedRoles();

    public void addRoleMapping(Mark var1, UUID var2);

    default public String internalToString() {
        StringBuilder result = new StringBuilder(this.getName() == null ? "" : this.getName());
        result.append(": ");
        boolean first = true;
        for (Waypoint waypoint : this.getWaypoints()) {
            if (!first) {
                result.append(" -> ");
            } else {
                first = false;
            }
            result.append(waypoint);
        }
        return result.toString();
    }
}

