/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.analyzing.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEndOfTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogStartOfTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogAnalyzer;
import com.sap.sse.common.Util;

public class TrackingTimesEventFinder
extends RaceLogAnalyzer<Util.Pair<RaceLogStartOfTrackingEvent, RaceLogEndOfTrackingEvent>> {
    public TrackingTimesEventFinder(RaceLog raceLog) {
        super(raceLog);
    }

    @Override
    protected Util.Pair<RaceLogStartOfTrackingEvent, RaceLogEndOfTrackingEvent> performAnalysis() {
        boolean startOfTrackingFound = false;
        boolean endOfTrackingFound = false;
        RaceLogStartOfTrackingEvent start = null;
        RaceLogEndOfTrackingEvent end = null;
        RaceLog raceLog = (RaceLog)this.getLog();
        for (RaceLogEvent event : raceLog.getUnrevokedEventsDescending()) {
            if (!startOfTrackingFound && event instanceof RaceLogStartOfTrackingEvent) {
                start = (RaceLogStartOfTrackingEvent)event;
                startOfTrackingFound = true;
            }
            if (!endOfTrackingFound && event instanceof RaceLogEndOfTrackingEvent) {
                end = (RaceLogEndOfTrackingEvent)event;
                endOfTrackingFound = true;
            }
            if (startOfTrackingFound && endOfTrackingFound) break;
        }
        Util.Pair result = startOfTrackingFound || endOfTrackingFound ? new Util.Pair(start, end) : null;
        return result;
    }
}

