/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.data.HasMarkPassingContext;
import com.sap.sailing.datamining.data.HasTrackedLegOfCompetitorContext;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.NauticalSide;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.Util;

public class MarkPassingWithContext
implements HasMarkPassingContext {
    private static final long serialVersionUID = -337042113749307686L;
    private final HasTrackedLegOfCompetitorContext trackedLegOfCompetitor;
    private final Maneuver maneuver;
    private Double absoluteRank;
    private boolean rankHasBeenInitialized;
    private Wind wind;

    public MarkPassingWithContext(HasTrackedLegOfCompetitorContext trackedLegOfCompetitor, Maneuver markPassingManeuver) {
        this.trackedLegOfCompetitor = trackedLegOfCompetitor;
        this.maneuver = markPassingManeuver;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.maneuver == null ? 0 : this.maneuver.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MarkPassingWithContext other = (MarkPassingWithContext)obj;
        return !(this.maneuver == null ? other.maneuver != null : !this.maneuver.equals(other.maneuver));
    }

    @Override
    public Wind getWindInternal() {
        return this.wind;
    }

    @Override
    public void setWindInternal(Wind wind) {
        this.wind = wind;
    }

    @Override
    public HasTrackedLegOfCompetitorContext getTrackedLegOfCompetitorContext() {
        return this.trackedLegOfCompetitor;
    }

    @Override
    public Maneuver getManeuver() {
        return this.maneuver;
    }

    @Override
    public Waypoint getWaypoint() {
        return this.getManeuver().getMarkPassing().getWaypoint();
    }

    @Override
    public NauticalSide getPassingSide() {
        return this.getManeuver().getToSide();
    }

    @Override
    public Double getRelativeRank() {
        Leaderboard leaderboard = this.getTrackedLegOfCompetitorContext().getTrackedLegContext().getTrackedRaceContext().getLeaderboardContext().getLeaderboard();
        double competitorCount = Util.size((Iterable)leaderboard.getCompetitors());
        return this.getAbsoluteRank() == null ? null : Double.valueOf(this.getAbsoluteRank() / competitorCount);
    }

    @Override
    public Double getAbsoluteRank() {
        if (!this.rankHasBeenInitialized) {
            Competitor competitor;
            TrackedRace trackedRace = this.getTrackedLegOfCompetitorContext().getTrackedRace();
            int rank = trackedRace.getRank(competitor = this.getTrackedLegOfCompetitorContext().getCompetitor(), this.getManeuver().getTimePoint());
            this.absoluteRank = rank == 0 ? null : Double.valueOf(rank);
            this.rankHasBeenInitialized = true;
        }
        return this.absoluteRank;
    }
}

