/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.racelogtracking.impl.fixtracker;

import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEventVisitor;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogCloseOpenEndedDeviceMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceBoatMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceBoatSensorDataMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceCompetitorMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceCompetitorSensorDataMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceMarkMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogRevokeEvent;
import com.sap.sailing.domain.abstractlog.regatta.impl.BaseRegattaLogEventVisitor;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogDeviceMappingFinder;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.racelogtracking.DeviceMappingWithRegattaLogEvent;
import com.sap.sailing.domain.tracking.DynamicTrack;
import com.sap.sse.common.MultiTimeRange;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import com.sap.sse.common.WithID;
import com.sap.sse.common.impl.MultiTimeRangeImpl;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RegattaLogDeviceMappings<ItemT extends WithID> {
    private static final Logger logger = Logger.getLogger(RegattaLogDeviceMappings.class.getName());
    private final Set<RegattaLog> knownRegattaLogs = new HashSet<RegattaLog>();
    private final NamedReentrantReadWriteLock knownRegattaLogsLock;
    private final NamedReentrantReadWriteLock mappingsLock;
    private final Map<ItemT, List<DeviceMappingWithRegattaLogEvent<ItemT>>> mappings = new HashMap<ItemT, List<DeviceMappingWithRegattaLogEvent<ItemT>>>();
    private final Map<DeviceIdentifier, List<DeviceMappingWithRegattaLogEvent<ItemT>>> mappingsByDevice = new HashMap<DeviceIdentifier, List<DeviceMappingWithRegattaLogEvent<ItemT>>>();
    private final RegattaLogEventVisitor regattaLogEventVisitor = new BaseRegattaLogEventVisitor(){

        public void visit(RegattaLogDeviceCompetitorSensorDataMappingEvent event) {
            logger.log(Level.FINE, "New CompetitorSensorDataMapping for: " + event.getMappedTo() + "; device: " + event.getDevice());
            RegattaLogDeviceMappings.this.updateMappings();
        }

        public void visit(RegattaLogDeviceBoatSensorDataMappingEvent event) {
            logger.log(Level.FINE, "New BoatSensorDataMapping for: " + event.getMappedTo() + "; device: " + event.getDevice());
            RegattaLogDeviceMappings.this.updateMappings();
        }

        public void visit(RegattaLogDeviceMarkMappingEvent event) {
            logger.log(Level.FINE, "New DeviceMarkMapping for: " + event.getMappedTo() + "; device: " + event.getDevice());
            RegattaLogDeviceMappings.this.updateMappings();
        }

        public void visit(RegattaLogDeviceCompetitorMappingEvent event) {
            logger.log(Level.FINE, "New DeviceCompetitorMapping for: " + event.getMappedTo() + "; device: " + event.getDevice());
            RegattaLogDeviceMappings.this.updateMappings();
        }

        public void visit(RegattaLogDeviceBoatMappingEvent event) {
            logger.log(Level.FINE, "New DeviceBoatMappingEvent for: " + event.getMappedTo() + "; device: " + event.getDevice());
            RegattaLogDeviceMappings.this.updateMappings();
        }

        public void visit(RegattaLogCloseOpenEndedDeviceMappingEvent event) {
            logger.log(Level.FINE, "CloseOpenEndedDeviceMapping closed: " + event.getDeviceMappingEventId());
            RegattaLogDeviceMappings.this.updateMappings();
        }

        public void visit(RegattaLogRevokeEvent event) {
            logger.log(Level.FINE, "Mapping revoked for: " + event.getRevokedEventId());
            RegattaLogDeviceMappings.this.updateMappings();
        }
    };

    public RegattaLogDeviceMappings(Iterable<RegattaLog> initialRegattaLogs, String raceNameForLock) {
        boolean hasRegattaLogs;
        this.mappingsLock = new NamedReentrantReadWriteLock("DeviceMapping lock for race " + raceNameForLock, false);
        this.knownRegattaLogsLock = new NamedReentrantReadWriteLock("Lock for known RegattaLogs of race " + raceNameForLock, false);
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.knownRegattaLogsLock);
        try {
            initialRegattaLogs.forEach(this::addRegattaLogUnlocked);
            hasRegattaLogs = !this.knownRegattaLogs.isEmpty();
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.knownRegattaLogsLock);
        }
        if (hasRegattaLogs) {
            this.updateMappings();
        }
    }

    public void addRegattaLog(RegattaLog regattaLog) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.knownRegattaLogsLock, () -> this.addRegattaLogUnlocked(regattaLog));
        this.updateMappings();
    }

    private void addRegattaLogUnlocked(RegattaLog log) {
        log.addListener((Object)this.regattaLogEventVisitor);
        this.knownRegattaLogs.add(log);
    }

    public void stop() {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.knownRegattaLogsLock, () -> this.knownRegattaLogs.forEach(log -> log.removeListener((Object)this.regattaLogEventVisitor)));
    }

    public void updateMappings() {
        try {
            this.updateMappingsInternal();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not update device mappings", e);
        }
    }

    public void forEachMappingOfDeviceIncludingTimePoint(DeviceIdentifier device, TimePoint timePoint, Consumer<DeviceMappingWithRegattaLogEvent<ItemT>> callback) {
        LockUtil.executeWithReadLock((NamedReentrantReadWriteLock)this.mappingsLock, () -> {
            List<DeviceMappingWithRegattaLogEvent<ItemT>> mappingsForDevice = this.mappingsByDevice.get(device);
            if (mappingsForDevice != null) {
                for (DeviceMappingWithRegattaLogEvent<ItemT> mapping : mappingsForDevice) {
                    if (!mapping.getTimeRange().includes(timePoint)) continue;
                    callback.accept(mapping);
                }
            }
        });
    }

    public void forEachItemAndCoveredTimeRanges(BiConsumer<ItemT, Map<RegattaLogDeviceMappingEvent<ItemT>, MultiTimeRange>> consumer) {
        HashMap allMappings = (HashMap)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.mappingsLock, () -> new HashMap<ItemT, List<DeviceMappingWithRegattaLogEvent<ItemT>>>(this.mappings));
        allMappings.forEach((item, mappings) -> {
            Map<RegattaLogDeviceMappingEvent<ItemT>, MultiTimeRange> coveredTimeRanges = this.calculateCoveredTimeRanges((List<DeviceMappingWithRegattaLogEvent<ItemT>>)mappings);
            consumer.accept(item, coveredTimeRanges);
        });
    }

    private Map<RegattaLogDeviceMappingEvent<ItemT>, MultiTimeRange> calculateCoveredTimeRanges(List<DeviceMappingWithRegattaLogEvent<ItemT>> mappingsForItem) {
        HashMap<RegattaLogDeviceMappingEvent<ItemT>, MultiTimeRange> coveredTimeRanges = new HashMap<RegattaLogDeviceMappingEvent<ItemT>, MultiTimeRange>();
        if (mappingsForItem != null) {
            Map<Util.Pair<DeviceIdentifier, Class<?>>, Iterable<DeviceMappingWithRegattaLogEvent<ItemT>>> groupedMappings = this.groupMappingsByDeviceIdAndMappingType(mappingsForItem);
            groupedMappings.entrySet().forEach(entry -> {
                Iterable mappingsForDeviceIdAndMappingType = (Iterable)entry.getValue();
                MultiTimeRange coveredTimeRange = this.getCoveredTimeRange(mappingsForDeviceIdAndMappingType);
                if (!coveredTimeRange.isEmpty()) {
                    coveredTimeRanges.put(((DeviceMappingWithRegattaLogEvent)Util.get((Iterable)mappingsForDeviceIdAndMappingType, (int)0)).getRegattaLogEvent(), coveredTimeRange);
                }
            });
        }
        return coveredTimeRanges;
    }

    protected Map<ItemT, List<DeviceMappingWithRegattaLogEvent<ItemT>>> calculateMappings() {
        HashMap result = new HashMap();
        this.forEachRegattaLog(log -> result.putAll((Map)new RegattaLogDeviceMappingFinder(log).analyze()));
        return result;
    }

    protected void forEachRegattaLog(Consumer<RegattaLog> regattaLogConsumer) {
        LockUtil.executeWithReadLock((NamedReentrantReadWriteLock)this.knownRegattaLogsLock, () -> this.knownRegattaLogs.forEach(regattaLogConsumer));
    }

    private final <FixT extends Timed, TrackT extends DynamicTrack<FixT>> void updateMappingsInternal() {
        Map<ItemT, List<DeviceMappingWithRegattaLogEvent<ItemT>>> newMappings;
        HashMap<ItemT, List<DeviceMappingWithRegattaLogEvent<ItemT>>> oldMappings = new HashMap<ItemT, List<DeviceMappingWithRegattaLogEvent<ItemT>>>();
        HashSet<DeviceIdentifier> oldDeviceIds = new HashSet<DeviceIdentifier>();
        HashSet<DeviceIdentifier> newDeviceIds = new HashSet<DeviceIdentifier>();
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.mappingsLock);
        try {
            newMappings = this.calculateMappings();
            oldMappings.putAll(this.mappings);
            oldDeviceIds.addAll(this.mappingsByDevice.keySet());
            this.mappings.clear();
            this.mappings.putAll(newMappings);
            this.mappingsByDevice.clear();
            for (WithID item : newMappings.keySet()) {
                for (DeviceMappingWithRegattaLogEvent<ItemT> mapping : newMappings.get(item)) {
                    List<DeviceMappingWithRegattaLogEvent<ItemT>> list = this.mappingsByDevice.get(mapping.getDevice());
                    if (list == null) {
                        list = new ArrayList<DeviceMappingWithRegattaLogEvent<ItemT>>();
                        this.mappingsByDevice.put(mapping.getDevice(), list);
                    }
                    list.add(mapping);
                }
            }
            newDeviceIds.addAll(this.mappingsByDevice.keySet());
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.mappingsLock);
        }
        this.calculateAndApplyDiff(oldMappings, newMappings, oldDeviceIds, newDeviceIds);
    }

    private void calculateAndApplyDiff(Map<ItemT, ? extends Iterable<DeviceMappingWithRegattaLogEvent<ItemT>>> previousMappings, Map<ItemT, ? extends Iterable<DeviceMappingWithRegattaLogEvent<ItemT>>> newMappings, Set<DeviceIdentifier> oldDeviceIds, Set<DeviceIdentifier> newDeviceIds) {
        HashSet<DeviceIdentifier> removedDeviceIds = new HashSet<DeviceIdentifier>(oldDeviceIds);
        removedDeviceIds.removeAll(newDeviceIds);
        removedDeviceIds.forEach(this::deviceIdRemovedInternal);
        HashSet<DeviceIdentifier> addedDeviceIds = new HashSet<DeviceIdentifier>(newDeviceIds);
        addedDeviceIds.removeAll(oldDeviceIds);
        addedDeviceIds.forEach(this::deviceIdAddedInternal);
        newMappings.forEach((item, mappingsForItem) -> {
            HashMap<RegattaLogDeviceMappingEvent<ItemT>, MultiTimeRange> newlyCoveredTimeRanges = new HashMap<RegattaLogDeviceMappingEvent<ItemT>, MultiTimeRange>();
            this.processNewAndChangedMappingsByDeviceIdAndEventType((Iterable)previousMappings.get(item), (Iterable<DeviceMappingWithRegattaLogEvent<ItemT>>)mappingsForItem, (deviceIdentifier, mappingType, oldMappingsForDeviceIdAndMappingType, newMappingsForDeviceIdAndMappingType) -> {
                assert (newMappingsForDeviceIdAndMappingType != null);
                assert (!Util.isEmpty((Iterable)newMappingsForDeviceIdAndMappingType));
                MultiTimeRange newCoveredTimeRanges = this.getCoveredTimeRange(newMappingsForDeviceIdAndMappingType).subtract(this.getCoveredTimeRange(oldMappingsForDeviceIdAndMappingType));
                if (!newCoveredTimeRanges.isEmpty()) {
                    newlyCoveredTimeRanges.put(((DeviceMappingWithRegattaLogEvent)Util.get((Iterable)newMappingsForDeviceIdAndMappingType, (int)0)).getRegattaLogEvent(), newCoveredTimeRanges);
                }
            });
            if (!newlyCoveredTimeRanges.isEmpty()) {
                this.newTimeRangesCoveredInternal(item, newlyCoveredTimeRanges);
            }
        });
    }

    private void processNewAndChangedMappingsByDeviceIdAndEventType(Iterable<DeviceMappingWithRegattaLogEvent<ItemT>> oldMappings, Iterable<DeviceMappingWithRegattaLogEvent<ItemT>> newMappings, GroupedOldAndNewMappingsCallback<ItemT> callback) {
        Map groupedOldMappings = this.groupMappingsByDeviceIdAndMappingType(oldMappings != null ? oldMappings : Collections.emptySet());
        Map<Util.Pair<DeviceIdentifier, Class<?>>, Iterable<DeviceMappingWithRegattaLogEvent<ItemT>>> groupedNewMappings = this.groupMappingsByDeviceIdAndMappingType(newMappings);
        groupedNewMappings.forEach((key, newMappingsForDeviceIdAndMappingType) -> {
            Set oldMappingsForDeviceIdAndMappingType = (Set)groupedOldMappings.get(key);
            callback.process((DeviceIdentifier)key.getA(), (Class)key.getB(), oldMappingsForDeviceIdAndMappingType != null ? oldMappingsForDeviceIdAndMappingType : Collections.emptySet(), (Iterable)newMappingsForDeviceIdAndMappingType);
        });
    }

    private Map<Util.Pair<DeviceIdentifier, Class<?>>, Iterable<DeviceMappingWithRegattaLogEvent<ItemT>>> groupMappingsByDeviceIdAndMappingType(Iterable<DeviceMappingWithRegattaLogEvent<ItemT>> mappings) {
        return Util.group(mappings, value -> new Util.Pair((Object)value.getDevice(), (Object)value.getEventType()), HashSet::new);
    }

    private MultiTimeRange getCoveredTimeRange(Iterable<DeviceMappingWithRegattaLogEvent<ItemT>> mappings) {
        MultiTimeRangeImpl result = new MultiTimeRangeImpl(new TimeRange[0]);
        for (DeviceMappingWithRegattaLogEvent<ItemT> mapping : mappings) {
            result = result.union(mapping.getTimeRange());
        }
        return result;
    }

    protected abstract void deviceIdAdded(DeviceIdentifier var1);

    private void deviceIdAddedInternal(DeviceIdentifier deviceIdentifier) {
        try {
            this.deviceIdAdded(deviceIdentifier);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "error while adding deviceIdentifier " + deviceIdentifier, e);
        }
    }

    protected abstract void deviceIdRemoved(DeviceIdentifier var1);

    private void deviceIdRemovedInternal(DeviceIdentifier deviceIdentifier) {
        try {
            this.deviceIdRemoved(deviceIdentifier);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "error while removing deviceIdentifier " + deviceIdentifier, e);
        }
    }

    protected abstract void newTimeRangesCovered(ItemT var1, Map<RegattaLogDeviceMappingEvent<ItemT>, MultiTimeRange> var2);

    private void newTimeRangesCoveredInternal(ItemT item, Map<RegattaLogDeviceMappingEvent<ItemT>, MultiTimeRange> newlyCoveredTimeRanges) {
        try {
            this.newTimeRangesCovered(item, newlyCoveredTimeRanges);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "error while calling newTimeRangeCovered for item " + item, e);
        }
    }

    private static interface GroupedOldAndNewMappingsCallback<ItemT extends WithID> {
        public void process(DeviceIdentifier var1, Class<?> var2, Iterable<DeviceMappingWithRegattaLogEvent<ItemT>> var3, Iterable<DeviceMappingWithRegattaLogEvent<ItemT>> var4);
    }
}

