/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.racelogtracking.impl;

import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.racelogtracking.impl.RaceLogConnectivityParams;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.impl.AbstractRaceTrackingConnectivityParametersHandler;
import com.sap.sailing.server.interfaces.RacingEventService;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class RaceLogConnectivityParamsHandler
extends AbstractRaceTrackingConnectivityParametersHandler {
    private static final String FLEET_NAME = "fleetName";
    private static final String RACE_COLUMN_NAME = "raceColumnName";
    private static final String LEADERBOARD_NAME = "leaderboardName";
    private static final String DELAY_TO_LIVE_IN_MILLIS = "delayToLiveInMillis";
    private final DomainFactory domainFactory;
    private final RacingEventService racingEventService;

    public RaceLogConnectivityParamsHandler(RacingEventService racingEventService) {
        this.racingEventService = racingEventService;
        this.domainFactory = racingEventService.getBaseDomainFactory();
    }

    public Map<String, Object> mapFrom(RaceTrackingConnectivityParameters params) {
        assert (params instanceof RaceLogConnectivityParams);
        RaceLogConnectivityParams rlParams = (RaceLogConnectivityParams)params;
        Map<String, Object> result = this.getKey(params);
        result.put(DELAY_TO_LIVE_IN_MILLIS, rlParams.getDelayToLiveInMillis());
        this.addWindTrackingParameters((RaceTrackingConnectivityParameters)rlParams, result);
        return result;
    }

    public RaceTrackingConnectivityParameters mapTo(Map<String, Object> map) throws MalformedURLException, URISyntaxException {
        RaceColumn raceColumn;
        RegattaLeaderboard leaderboard = (RegattaLeaderboard)this.racingEventService.getLeaderboardByName((String)map.get(LEADERBOARD_NAME));
        RaceLogConnectivityParams result = leaderboard == null ? null : ((raceColumn = leaderboard.getRaceColumnByName((String)map.get(RACE_COLUMN_NAME))) == null ? null : new RaceLogConnectivityParams(this.racingEventService.getServerAuthor(), leaderboard.getRegatta(), raceColumn, raceColumn.getFleetByName((String)map.get(FLEET_NAME)), (Leaderboard)leaderboard, ((Number)map.get(DELAY_TO_LIVE_IN_MILLIS)).longValue(), this.domainFactory, this.isTrackWind(map), this.isCorrectWindDirectionByMagneticDeclination(map)));
        return result;
    }

    public Map<String, Object> getKey(RaceTrackingConnectivityParameters params) {
        assert (params instanceof RaceLogConnectivityParams);
        RaceLogConnectivityParams rlParams = (RaceLogConnectivityParams)params;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("type", params.getTypeIdentifier());
        result.put(LEADERBOARD_NAME, rlParams.getLeaderboard().getName());
        result.put(RACE_COLUMN_NAME, rlParams.getRaceColumn().getName());
        result.put(FLEET_NAME, rlParams.getFleet().getName());
        return result;
    }

    public RaceTrackingConnectivityParameters resolve(RaceTrackingConnectivityParameters params) throws Exception {
        assert (params instanceof RaceTrackingConnectivityParameters);
        RaceLogConnectivityParams rLParams = (RaceLogConnectivityParams)params;
        RaceLogConnectivityParams result = new RaceLogConnectivityParams(this.racingEventService.getServerAuthor(), rLParams.getRegatta(), rLParams.getRaceColumn(), rLParams.getFleet(), rLParams.getLeaderboard(), rLParams.getDelayToLiveInMillis(), this.domainFactory, rLParams.isTrackWind(), rLParams.isCorrectWindDirectionByMagneticDeclination());
        return result;
    }
}

