/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter;

import com.sap.sse.InvalidDateException;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.util.DateParser;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RaceRecord {
    private static final Logger logger = Logger.getLogger(RaceRecord.class.getName());
    private static final String LIVE_URI_PROPERTY = "live-uri";
    private static final String STORED_URI_PROPERTY = "stored-uri";
    private final String regattaName;
    private final String name;
    private final String replayURL;
    private final String ID;
    private final URL paramURL;
    private final TimePoint trackingstarttime;
    private final TimePoint trackingendtime;
    private final TimePoint racestarttime;
    private final URI liveURI;
    private final URI storedURI;
    private final List<String> boatClassNames;
    private final String raceStatus;
    private final String raceVisibility;
    private final boolean hasReplay;
    private final URL jsonUrl;
    private final URI defaultUpdateURI;

    public RaceRecord(URL jsonURL, String regattaName, String name, String replayURL, String paramURLAsString, String ID, String trackingstarttime, String trackingendtime, String racestarttime, String commaSeparatedBoatClassNames, String status, String visibility, boolean hasReplay, boolean loadLiveAndStoredURI, String defaultUpdateURI, String tracTracApiToken) throws URISyntaxException, IOException {
        this.regattaName = regattaName;
        this.name = name;
        this.replayURL = replayURL;
        this.raceStatus = status;
        this.raceVisibility = visibility;
        this.hasReplay = hasReplay;
        this.ID = ID;
        this.jsonUrl = jsonURL;
        this.boatClassNames = new ArrayList<String>();
        if (commaSeparatedBoatClassNames != null) {
            String[] stringArray = commaSeparatedBoatClassNames.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String boatClassName = stringArray[n2];
                this.boatClassNames.add(boatClassName.trim());
                ++n2;
            }
        }
        MillisecondsTimePoint tp = null;
        if (trackingstarttime != null) {
            try {
                tp = new MillisecondsTimePoint(DateParser.parseUTC((String)trackingstarttime).getTime());
            }
            catch (InvalidDateException e) {
                logger.warning("Unable to parse trackingstarttime of race " + name + ": " + trackingstarttime + ". Leaving null.");
            }
        }
        this.trackingstarttime = tp;
        tp = null;
        if (trackingendtime != null) {
            try {
                tp = new MillisecondsTimePoint(DateParser.parseUTC((String)trackingendtime).getTime());
            }
            catch (InvalidDateException e) {
                logger.warning("Unable to parse trackingendtime of race " + name + ": " + trackingendtime + ". Leaving null.");
            }
        }
        this.trackingendtime = tp;
        tp = null;
        if (racestarttime != null) {
            try {
                tp = new MillisecondsTimePoint(DateParser.parseUTC((String)racestarttime).getTime());
            }
            catch (InvalidDateException e) {
                logger.warning("Unable to parse racestarttime of race " + name + ": " + racestarttime + ". Leaving null.");
            }
        }
        this.racestarttime = tp;
        String technicalEventName = this.getTechnicalEventName(jsonURL);
        String baseJsonURL = this.getBaseURL(jsonURL);
        try {
            this.paramURL = paramURLAsString == null || paramURLAsString.isEmpty() ? new URL(String.valueOf(baseJsonURL) + "/clientparams.php?event=" + technicalEventName + "&race=" + ID) : new URL(jsonURL, paramURLAsString);
        }
        catch (Exception e) {
            logger.info("Couldn't parse TracTrac paramURL " + paramURLAsString + " for race record " + this.getName());
            logger.log(Level.INFO, "The exception was:", e);
            throw e;
        }
        if (loadLiveAndStoredURI) {
            Map<String, String> paramURLContents = this.parseParams(this.paramURL, tracTracApiToken);
            String liveURIAsString = paramURLContents.get(LIVE_URI_PROPERTY);
            this.liveURI = liveURIAsString == null ? null : new URI(liveURIAsString);
            String storedURIAsString = paramURLContents.get(STORED_URI_PROPERTY);
            this.storedURI = storedURIAsString == null || storedURIAsString.startsWith("tcp:") || storedURIAsString.startsWith("http:") || storedURIAsString.startsWith("https:") ? (storedURIAsString == null ? null : new URI(storedURIAsString)) : new URI(String.valueOf(this.getBaseURL(this.paramURL)) + "/" + storedURIAsString);
        } else {
            paramURLAsString = null;
            this.liveURI = null;
            this.storedURI = null;
        }
        this.defaultUpdateURI = defaultUpdateURI == null ? null : new URI(defaultUpdateURI);
    }

    private String getBaseURL(URL url) {
        String jsonURLAsString = url.toString();
        int indexOfLastSlash = jsonURLAsString.lastIndexOf(47);
        String baseURL = jsonURLAsString.substring(0, indexOfLastSlash);
        return baseURL;
    }

    private String getTechnicalEventName(URL jsonUrl) {
        String jsonURLAsString = jsonUrl.toString();
        int indexOfLastSlash = jsonURLAsString.lastIndexOf(47);
        int indexOfLastButOneSlash = jsonURLAsString.lastIndexOf(47, indexOfLastSlash - 1);
        String technicalEventName = jsonURLAsString.substring(indexOfLastButOneSlash + 1, indexOfLastSlash);
        return technicalEventName;
    }

    private Map<String, String> parseParams(URL paramURL, String tracTracApiToken) throws IOException {
        String line;
        HashMap<String, String> result = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("^([^:]*):(.*)$");
        URLConnection connection = HttpUrlConnectionHelper.redirectConnection((URL)paramURL, (Duration)Duration.ONE_MINUTE, c -> {
            if (Util.hasLength((String)tracTracApiToken)) {
                c.setRequestProperty("Authorization", "Bearer " + tracTracApiToken);
            }
        });
        Charset charset = HttpUrlConnectionHelper.getCharsetFromConnectionOrDefault((URLConnection)connection, (String)"UTF-8");
        BufferedReader r = new BufferedReader(new InputStreamReader(connection.getInputStream(), charset));
        while ((line = r.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            result.put(matcher.group(1), matcher.group(2));
        }
        return result;
    }

    public boolean hasLiveAndStoredURI() {
        return this.liveURI != null;
    }

    public boolean hasReplay() {
        return this.hasReplay;
    }

    public String getName() {
        return this.name;
    }

    public String getEventName() {
        return this.regattaName;
    }

    public String getReplayURL() {
        return this.replayURL;
    }

    public URI getLiveURI() {
        return this.liveURI;
    }

    public URI getStoredURI() {
        return this.storedURI;
    }

    public String getID() {
        return this.ID;
    }

    public URL getParamURL() {
        return this.paramURL;
    }

    public Iterable<String> getBoatClassNames() {
        return this.boatClassNames;
    }

    public TimePoint getTrackingStartTime() {
        return this.trackingstarttime;
    }

    public TimePoint getTrackingEndTime() {
        return this.trackingendtime;
    }

    public TimePoint getRaceStartTime() {
        return this.racestarttime;
    }

    public String getRaceStatus() {
        return this.raceStatus;
    }

    public String getRaceVisibility() {
        return this.raceVisibility;
    }

    public URL getJsonURL() {
        return this.jsonUrl;
    }

    public URI getDefaultUpdateURI() {
        return this.defaultUpdateURI;
    }
}

