/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.persistence.racelog.tracking.impl;

import com.mongodb.ReadConcern;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.lang.Nullable;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.persistence.DomainObjectFactory;
import com.sap.sailing.domain.persistence.FieldNames;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.domain.persistence.racelog.tracking.FixMongoHandler;
import com.sap.sailing.domain.persistence.racelog.tracking.MongoSensorFixStore;
import com.sap.sailing.domain.persistence.racelog.tracking.impl.MetadataCollection;
import com.sap.sailing.domain.persistence.racelog.tracking.impl.MongoFixHandler;
import com.sap.sailing.domain.racelog.tracking.FixReceivedListener;
import com.sap.sailing.shared.persistence.device.DeviceIdentifierMongoHandler;
import com.sap.sailing.shared.persistence.impl.MongoObjectFactoryImpl;
import com.sap.sse.common.Duration;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Timed;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.common.TypeBasedServiceFinderFactory;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.TimeRangeImpl;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoSensorFixStoreImpl
extends MongoFixHandler
implements MongoSensorFixStore {
    private static final Logger logger = Logger.getLogger(MongoSensorFixStoreImpl.class.getName());
    private final MongoCollection<Document> fixesCollection;
    private final MetadataCollection metadataCollection;
    private final com.sap.sailing.domain.persistence.impl.MongoObjectFactoryImpl mongoOF;
    @Nullable
    private final ClientSession clientSession;
    private final WriteConcern writeConcern;
    private final ReadConcern readConcern;
    private final NamedReentrantReadWriteLock listenersLock = new NamedReentrantReadWriteLock("Listeners collection lock of " + MongoSensorFixStoreImpl.class.getName(), false);
    private final Map<DeviceIdentifier, Set<FixReceivedListener<? extends Timed>>> listeners = new HashMap<DeviceIdentifier, Set<FixReceivedListener<? extends Timed>>>();

    public MongoSensorFixStoreImpl(MongoObjectFactory mongoObjectFactory, DomainObjectFactory domainObjectFactory, TypeBasedServiceFinderFactory serviceFinderFactory) {
        this(mongoObjectFactory, domainObjectFactory, serviceFinderFactory, ReadConcern.DEFAULT, WriteConcern.UNACKNOWLEDGED, null, null);
    }

    public MongoSensorFixStoreImpl(MongoObjectFactory mongoObjectFactory, DomainObjectFactory domainObjectFactory, TypeBasedServiceFinderFactory serviceFinderFactory, ReadConcern readConcern, WriteConcern writeConcern, ClientSession clientSession, ClientSession metadataCollectionClientSession) {
        super(serviceFinderFactory != null ? MongoSensorFixStoreImpl.createFixServiceFinder(serviceFinderFactory) : null, serviceFinderFactory != null ? serviceFinderFactory.createServiceFinder(DeviceIdentifierMongoHandler.class) : null);
        this.mongoOF = (com.sap.sailing.domain.persistence.impl.MongoObjectFactoryImpl)mongoObjectFactory;
        this.fixesCollection = this.mongoOF.getGPSFixCollection(clientSession);
        this.metadataCollection = new MetadataCollection(this.mongoOF, this.fixServiceFinder, (TypeBasedServiceFinder<DeviceIdentifierMongoHandler>)this.deviceServiceFinder, readConcern, writeConcern, metadataCollectionClientSession);
        this.writeConcern = writeConcern;
        this.readConcern = readConcern;
        this.clientSession = clientSession;
    }

    private static TypeBasedServiceFinder<FixMongoHandler<?>> createFixServiceFinder(TypeBasedServiceFinderFactory serviceFinderFactory) {
        return serviceFinderFactory.createServiceFinder(FixMongoHandler.class);
    }

    public <FixT extends Timed> boolean loadOldestFix(Consumer<FixT> consumer, DeviceIdentifier device, TimeRange timeRangeToLoad) throws NoCorrespondingServiceRegisteredException, TransformationException {
        return this.loadFixes(consumer, device, timeRangeToLoad.from(), timeRangeToLoad.to(), false, () -> false, d -> {}, true, true);
    }

    public <FixT extends Timed> boolean loadYoungestFix(Consumer<FixT> consumer, DeviceIdentifier device, TimeRange timeRangeToLoad) throws NoCorrespondingServiceRegisteredException, TransformationException {
        return this.loadFixes(consumer, device, timeRangeToLoad.from(), timeRangeToLoad.to(), false, () -> false, d -> {}, false, true);
    }

    public <FixT extends Timed> void loadFixes(Consumer<FixT> consumer, DeviceIdentifier device, TimePoint from, TimePoint to, boolean inclusive) throws NoCorrespondingServiceRegisteredException, TransformationException {
        this.loadFixes(consumer, device, from, to, inclusive, () -> false, d -> {});
    }

    public <FixT extends Timed> void loadFixes(Consumer<FixT> consumer, DeviceIdentifier device, TimePoint from, TimePoint to, boolean inclusive, BooleanSupplier isPreemptiveStopped, Consumer<Double> progressConsumer) throws NoCorrespondingServiceRegisteredException, TransformationException {
        this.loadFixes(consumer, device, from, to, inclusive, isPreemptiveStopped, progressConsumer, true, false);
    }

    private <FixT extends Timed> boolean loadFixes(Consumer<FixT> consumer, DeviceIdentifier device, TimePoint from, TimePoint to, boolean inclusive, BooleanSupplier isPreemptiveStopped, Consumer<Double> progressConsumer, boolean ascending, boolean onlyOneResult) throws NoCorrespondingServiceRegisteredException, TransformationException {
        progressConsumer.accept(0.0);
        TimePoint loadFixesFrom = from == null ? TimePoint.BeginningOfTime : from;
        TimePoint loadFixesTo = to == null ? TimePoint.EndOfTime : to;
        Bson dbDeviceId = MongoObjectFactoryImpl.getDeviceQuery((TypeBasedServiceFinder)this.deviceServiceFinder, (DeviceIdentifier)device);
        ArrayList<Bson> filters = new ArrayList<Bson>();
        filters.add(dbDeviceId);
        filters.add(Filters.gte((String)FieldNames.TIME_AS_MILLIS.name(), (Object)loadFixesFrom.asMillis()));
        if (inclusive) {
            filters.add(Filters.lte((String)FieldNames.TIME_AS_MILLIS.name(), (Object)loadFixesTo.asMillis()));
        } else {
            filters.add(Filters.lt((String)FieldNames.TIME_AS_MILLIS.name(), (Object)loadFixesTo.asMillis()));
        }
        Bson query = Filters.and(filters);
        MongoCollection fixesCollectionWithReadConcern = this.fixesCollection.withReadConcern(this.readConcern);
        FindIterable result = this.clientSession == null ? fixesCollectionWithReadConcern.find(query) : fixesCollectionWithReadConcern.find(this.clientSession, query);
        result.batchSize(100000).sort((Bson)new Document(FieldNames.TIME_AS_MILLIS.name(), (Object)(ascending ? 1 : -1)));
        if (onlyOneResult) {
            result.limit(1);
        }
        boolean fixLoaded = false;
        Duration totalDurationToLoad = loadFixesFrom.until(loadFixesTo);
        Duration minimumDurationBetweenProgressUpdates = (Duration)Util.max((Comparable[])new Duration[]{totalDurationToLoad.divide(20L), Duration.ONE_MINUTE.times(5L)});
        TimePoint nextProgressUpdateAt = ascending ? loadFixesFrom.plus(minimumDurationBetweenProgressUpdates) : loadFixesTo.minus(minimumDurationBetweenProgressUpdates);
        for (Document fixObject : result) {
            try {
                Object fix = this.loadFix(fixObject);
                consumer.accept(fix);
                fixLoaded = true;
                TimePoint fixTimePoint = fix.getTimePoint();
                if (!(ascending ? fixTimePoint.after(nextProgressUpdateAt) : fixTimePoint.before(nextProgressUpdateAt))) continue;
                Duration durationAlreadyLoaded = ascending ? loadFixesFrom.until(fixTimePoint) : fixTimePoint.until(loadFixesTo);
                progressConsumer.accept(durationAlreadyLoaded.divide(totalDurationToLoad));
                TimePoint timePoint = nextProgressUpdateAt = ascending ? fixTimePoint.plus(minimumDurationBetweenProgressUpdates) : fixTimePoint.minus(minimumDurationBetweenProgressUpdates);
                if (!isPreemptiveStopped.getAsBoolean()) continue;
                logger.log(Level.WARNING, "Exiting because of preemtive stop requested " + fixObject);
                return fixLoaded;
            }
            catch (TransformationException e) {
                logger.log(Level.WARNING, "Could not read fix from MongoDB: " + fixObject);
            }
            catch (ClassCastException e) {
                String type = (String)fixObject.get((Object)FieldNames.GPSFIX_TYPE.name());
                logger.log(Level.WARNING, "Unexpected fix type (" + type + ") encountered when trying to load track for " + device);
            }
        }
        progressConsumer.accept(1.0);
        return fixLoaded;
    }

    public <FixT extends Timed> Iterable<Util.Triple<RegattaAndRaceIdentifier, Boolean, Duration>> storeFixes(DeviceIdentifier device, Iterable<FixT> fixes, boolean returnManeuverChanges, boolean returnLiveDelay) {
        HashSet<Util.Triple<RegattaAndRaceIdentifier, Boolean, Duration>> racesWithManeuverChangesOrLiveDelay = new HashSet<Util.Triple<RegattaAndRaceIdentifier, Boolean, Duration>>();
        if (!Util.isEmpty(fixes)) {
            try {
                Document dbDeviceId = MongoObjectFactoryImpl.storeDeviceId((TypeBasedServiceFinder)this.deviceServiceFinder, (DeviceIdentifier)device);
                int nrOfTotalFixes = Util.size(fixes);
                ArrayList<Document> dbFixes = new ArrayList<Document>(nrOfTotalFixes);
                TimeRangeImpl newTimeRange = null;
                Timed latestFix = null;
                for (Timed fix : fixes) {
                    if (latestFix == null || latestFix.getTimePoint().before(fix.getTimePoint())) {
                        latestFix = fix;
                    }
                    Document entry = new Document().append(FieldNames.DEVICE_ID.name(), (Object)dbDeviceId);
                    this.storeFixToDocument(entry, fix);
                    this.mongoOF.storeTimed(fix, entry);
                    dbFixes.add(entry);
                    TimePoint fixTP = fix.getTimePoint();
                    TimeRangeImpl fixTimeRange = new TimeRangeImpl(fixTP, fixTP, true);
                    Object object = newTimeRange = newTimeRange == null ? fixTimeRange : newTimeRange.extend((TimeRange)fixTimeRange);
                }
                MongoCollection fixesCollectionWithWriteConcern = this.fixesCollection.withWriteConcern(this.writeConcern);
                if (this.clientSession == null) {
                    fixesCollectionWithWriteConcern.insertMany(dbFixes);
                } else {
                    fixesCollectionWithWriteConcern.insertMany(this.clientSession, dbFixes);
                }
                this.metadataCollection.enqueueMetadataUpdate(device, dbDeviceId, nrOfTotalFixes, (TimeRange)newTimeRange, latestFix);
            }
            catch (TransformationException e) {
                logger.log(Level.WARNING, "Could not store fix in MongoDB", e);
            }
            Util.addAll(this.notifyListeners(device, fixes, returnManeuverChanges, returnLiveDelay), racesWithManeuverChangesOrLiveDelay);
        }
        return racesWithManeuverChangesOrLiveDelay;
    }

    public <FixT extends Timed> void storeFix(DeviceIdentifier device, FixT fix) {
        this.storeFixes(device, Collections.singletonList(fix), false, false);
    }

    private <FixT extends Timed> Iterable<Util.Triple<RegattaAndRaceIdentifier, Boolean, Duration>> notifyListeners(DeviceIdentifier device, Iterable<FixT> fixes, boolean returnManeuverChanges, boolean returnLiveDelay) {
        HashSet<Util.Triple<RegattaAndRaceIdentifier, Boolean, Duration>> raceWithChangedManeuver = new HashSet<Util.Triple<RegattaAndRaceIdentifier, Boolean, Duration>>();
        Map<DeviceIdentifier, Set<FixReceivedListener<? extends Timed>>> listenersWithFixType = this.listeners;
        Set listenersToInform = (Set)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.listenersLock, () -> new HashSet((Collection)Util.get((Map)listenersWithFixType, (Object)device, Collections.emptySet())));
        for (Timed fix : fixes) {
            for (FixReceivedListener listener : listenersToInform) {
                Iterable racesWithManeuverChangeFromListener = listener.fixReceived(device, fix, returnManeuverChanges, returnLiveDelay);
                Util.addAll((Iterable)racesWithManeuverChangeFromListener, raceWithChangedManeuver);
            }
        }
        return raceWithChangedManeuver;
    }

    public void addListener(FixReceivedListener<? extends Timed> listener, DeviceIdentifier device) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.listenersLock, () -> {
            boolean bl = Util.addToValueSet(this.listeners, (Object)device, (Object)listener);
        });
    }

    public void removeListener(FixReceivedListener<? extends Timed> listener) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.listenersLock, () -> Util.removeFromAllValueSets(this.listeners, (Object)listener));
    }

    public void removeListener(FixReceivedListener<? extends Timed> listener, DeviceIdentifier device) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.listenersLock, () -> {
            boolean bl = Util.removeFromValueSet(this.listeners, (Object)device, (Object)listener);
        });
    }

    public TimeRange getTimeRangeCoveredByFixes(DeviceIdentifier device) throws TransformationException, NoCorrespondingServiceRegisteredException {
        return this.getMetadataCollection().getTimeRangeCoveredByFixes(device);
    }

    private MetadataCollection getMetadataCollection() {
        return this.metadataCollection;
    }

    public long getNumberOfFixes(DeviceIdentifier device) throws TransformationException, NoCorrespondingServiceRegisteredException {
        return this.metadataCollection.getNumberOfFixes(device);
    }

    public <FixT extends Timed> Map<DeviceIdentifier, FixT> getFixLastReceived(Iterable<DeviceIdentifier> forDevices) throws TransformationException, NoCorrespondingServiceRegisteredException {
        return this.metadataCollection.getFixLastReceived(forDevices);
    }
}

