/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.i18n.impl;

import com.sap.sse.i18n.ResourceBundleStringMessages;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompoundResourceBundleStringMessages
implements ResourceBundleStringMessages {
    private static final Logger LOGGER = Logger.getLogger(CompoundResourceBundleStringMessages.class.getSimpleName());
    private final Collection<ResourceBundleStringMessages> stringMessages;

    public CompoundResourceBundleStringMessages() {
        this.stringMessages = new HashSet<ResourceBundleStringMessages>();
    }

    public CompoundResourceBundleStringMessages(Collection<ResourceBundleStringMessages> stringMessages) {
        this.stringMessages = new HashSet<ResourceBundleStringMessages>(stringMessages);
    }

    public boolean addStringMessages(ResourceBundleStringMessages stringMessages) {
        return this.stringMessages.add(stringMessages);
    }

    public boolean removeStringMessages(ResourceBundleStringMessages stringMessages) {
        return this.stringMessages.remove(stringMessages);
    }

    @Override
    public String get(Locale locale, String messageKey) {
        return this.get(locale, messageKey, new String[0]);
    }

    @Override
    public String get(Locale locale, String messageKey, String ... parameters) {
        HashMap<ResourceBundleStringMessages, String> messages = new HashMap<ResourceBundleStringMessages, String>();
        for (ResourceBundleStringMessages stringMessages : this.stringMessages) {
            try {
                messages.put(stringMessages, stringMessages.get(locale, messageKey, parameters));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return this.getBestMessageAndLogConflicts(messageKey, messages);
    }

    private String getBestMessageAndLogConflicts(String messageKey, Map<ResourceBundleStringMessages, String> messages) throws MissingResourceException {
        String bestMessageResourceBaseName = null;
        String bestMessage = null;
        for (Map.Entry<ResourceBundleStringMessages, String> messagesEntry : messages.entrySet()) {
            String message = messagesEntry.getValue();
            if (message == null) continue;
            if (bestMessage == null) {
                bestMessage = message;
                bestMessageResourceBaseName = messagesEntry.getKey().getResourceBaseName();
                continue;
            }
            this.logPossibleConflicts(messageKey, bestMessageResourceBaseName, bestMessage, messagesEntry);
        }
        if (bestMessage == null) {
            throw new MissingResourceException("Can't find message for bundle " + this.getClass().getName() + ", key '" + messageKey + "'", this.getClass().getName(), messageKey);
        }
        return bestMessage;
    }

    private void logPossibleConflicts(String messageKey, String bestMessageResourceBaseName, String bestMessage, Map.Entry<ResourceBundleStringMessages, String> messagesEntry) {
        String messageResourceBaseName = messagesEntry.getKey().getResourceBaseName();
        String message = messagesEntry.getValue();
        if (bestMessage.equals(message)) {
            LOGGER.log(Level.INFO, "The resources " + bestMessageResourceBaseName + " and " + messageResourceBaseName + " contain the same message '" + bestMessage + "' for the key '" + messageKey + "'");
        } else {
            LOGGER.log(Level.INFO, "The resources " + bestMessageResourceBaseName + " and " + messageResourceBaseName + " contain different messages '" + bestMessage + "' and '" + message + "' for the key '" + messageKey + "'");
        }
    }

    @Override
    public String getResourceBaseName() {
        return "This implementations has multiple resource bundles";
    }
}

