/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.marineapi.nmea.parser.APBParser;
import net.sf.marineapi.nmea.parser.BODParser;
import net.sf.marineapi.nmea.parser.CURParser;
import net.sf.marineapi.nmea.parser.DBTParser;
import net.sf.marineapi.nmea.parser.DPTParser;
import net.sf.marineapi.nmea.parser.DTMParser;
import net.sf.marineapi.nmea.parser.GGAParser;
import net.sf.marineapi.nmea.parser.GLLParser;
import net.sf.marineapi.nmea.parser.GNSParser;
import net.sf.marineapi.nmea.parser.GSAParser;
import net.sf.marineapi.nmea.parser.GSTParser;
import net.sf.marineapi.nmea.parser.GSVParser;
import net.sf.marineapi.nmea.parser.HDGParser;
import net.sf.marineapi.nmea.parser.HDMParser;
import net.sf.marineapi.nmea.parser.HDTParser;
import net.sf.marineapi.nmea.parser.MDAParser;
import net.sf.marineapi.nmea.parser.MHUParser;
import net.sf.marineapi.nmea.parser.MMBParser;
import net.sf.marineapi.nmea.parser.MTAParser;
import net.sf.marineapi.nmea.parser.MTWParser;
import net.sf.marineapi.nmea.parser.MWDParser;
import net.sf.marineapi.nmea.parser.MWVParser;
import net.sf.marineapi.nmea.parser.RMBParser;
import net.sf.marineapi.nmea.parser.RMCParser;
import net.sf.marineapi.nmea.parser.ROTParser;
import net.sf.marineapi.nmea.parser.RPMParser;
import net.sf.marineapi.nmea.parser.RSAParser;
import net.sf.marineapi.nmea.parser.RTEParser;
import net.sf.marineapi.nmea.parser.STALKParser;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.parser.TTMParser;
import net.sf.marineapi.nmea.parser.VBWParser;
import net.sf.marineapi.nmea.parser.VDMParser;
import net.sf.marineapi.nmea.parser.VDOParser;
import net.sf.marineapi.nmea.parser.VDRParser;
import net.sf.marineapi.nmea.parser.VHWParser;
import net.sf.marineapi.nmea.parser.VLWParser;
import net.sf.marineapi.nmea.parser.VTGParser;
import net.sf.marineapi.nmea.parser.VWRParser;
import net.sf.marineapi.nmea.parser.VWTParser;
import net.sf.marineapi.nmea.parser.WPLParser;
import net.sf.marineapi.nmea.parser.XDRParser;
import net.sf.marineapi.nmea.parser.XTEParser;
import net.sf.marineapi.nmea.parser.ZDAParser;
import net.sf.marineapi.nmea.sentence.Sentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;

public final class SentenceFactory {
    private static Map<String, Class<? extends SentenceParser>> parsers;
    private static volatile SentenceFactory instance;

    private SentenceFactory() {
        this.reset();
    }

    public Sentence createParser(String nmea) {
        String sid = SentenceId.parseStr(nmea);
        return this.createParserImpl(sid, nmea);
    }

    public Sentence createParser(TalkerId talker, SentenceId type) {
        return this.createParser(talker, type.toString());
    }

    public Sentence createParser(TalkerId talker, String type) {
        if (talker == null) {
            throw new IllegalArgumentException("TalkerId cannot be null");
        }
        return this.createParserImpl(type, (Object)talker);
    }

    public boolean hasParser(String type) {
        return parsers.containsKey(type);
    }

    public List<String> listParsers() {
        Set<String> keys = parsers.keySet();
        return Arrays.asList(keys.toArray(new String[parsers.size()]));
    }

    public void registerParser(String type, Class<? extends SentenceParser> parser) {
        try {
            parser.getConstructor(String.class);
            parser.getConstructor(TalkerId.class);
            parsers.put(type, parser);
        }
        catch (SecurityException e) {
            String msg = "Unable to register parser due security violation";
            throw new IllegalArgumentException(msg, e);
        }
        catch (NoSuchMethodException e) {
            String msg = "Required constructors not found; SentenceParser(String), SentenceParser(TalkerId)";
            throw new IllegalArgumentException(msg, e);
        }
    }

    public void unregisterParser(Class<? extends SentenceParser> parser) {
        for (String key : parsers.keySet()) {
            if (parsers.get(key) != parser) continue;
            parsers.remove(key);
            break;
        }
    }

    private Sentence createParserImpl(String sid, Object param) {
        if (!this.hasParser(sid)) {
            String msg = String.format("Parser for type '%s' not found", sid);
            throw new IllegalArgumentException(msg);
        }
        Sentence parser = null;
        Class<?> klass = param.getClass();
        try {
            Class<? extends SentenceParser> c = parsers.get(sid);
            Constructor<? extends SentenceParser> co = c.getConstructor(klass);
            parser = co.newInstance(param);
        }
        catch (NoSuchMethodException e) {
            String name = klass.getName();
            String msg = "Constructor with %s parameter not found";
            throw new IllegalStateException(String.format(msg, name), e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Unable to instantiate parser", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to access parser", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Unable to invoke parser constructor", e);
        }
        return parser;
    }

    public static synchronized SentenceFactory getInstance() {
        if (instance == null) {
            instance = new SentenceFactory();
        }
        return instance;
    }

    public void reset() {
        parsers = new HashMap<String, Class<? extends SentenceParser>>();
        this.registerParser("APB", APBParser.class);
        this.registerParser("ALK", STALKParser.class);
        this.registerParser("BOD", BODParser.class);
        this.registerParser("CUR", CURParser.class);
        this.registerParser("DBT", DBTParser.class);
        this.registerParser("DPT", DPTParser.class);
        this.registerParser("DTM", DTMParser.class);
        this.registerParser("GGA", GGAParser.class);
        this.registerParser("GLL", GLLParser.class);
        this.registerParser("GNS", GNSParser.class);
        this.registerParser("GSA", GSAParser.class);
        this.registerParser("GST", GSTParser.class);
        this.registerParser("GSV", GSVParser.class);
        this.registerParser("HDG", HDGParser.class);
        this.registerParser("HDM", HDMParser.class);
        this.registerParser("HDT", HDTParser.class);
        this.registerParser("MHU", MHUParser.class);
        this.registerParser("MMB", MMBParser.class);
        this.registerParser("MTA", MTAParser.class);
        this.registerParser("MTW", MTWParser.class);
        this.registerParser("MWV", MWVParser.class);
        this.registerParser("RMB", RMBParser.class);
        this.registerParser("RMC", RMCParser.class);
        this.registerParser("RPM", RPMParser.class);
        this.registerParser("ROT", ROTParser.class);
        this.registerParser("RTE", RTEParser.class);
        this.registerParser("RSA", RSAParser.class);
        this.registerParser("TTM", TTMParser.class);
        this.registerParser("VBW", VBWParser.class);
        this.registerParser("VDM", VDMParser.class);
        this.registerParser("VDO", VDOParser.class);
        this.registerParser("VDR", VDRParser.class);
        this.registerParser("VHW", VHWParser.class);
        this.registerParser("VLW", VLWParser.class);
        this.registerParser("VTG", VTGParser.class);
        this.registerParser("VWR", VWRParser.class);
        this.registerParser("VWT", VWTParser.class);
        this.registerParser("WPL", WPLParser.class);
        this.registerParser("XTE", XTEParser.class);
        this.registerParser("XDR", XDRParser.class);
        this.registerParser("ZDA", ZDAParser.class);
        this.registerParser("MDA", MDAParser.class);
        this.registerParser("MWD", MWDParser.class);
    }
}

