/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.RPMSentence;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.DataStatus;

class RPMParser
extends SentenceParser
implements RPMSentence {
    private static final int SOURCE = 0;
    private static final int SOURCE_NUMBER = 1;
    private static final int REVOLUTIONS = 2;
    private static final int PITCH = 3;
    private static final int STATUS = 4;

    public RPMParser(String nmea) {
        super(nmea);
    }

    public RPMParser(TalkerId talker) {
        super(talker, "RPM", 5);
    }

    @Override
    public int getId() {
        return this.getIntValue(1);
    }

    @Override
    public double getPitch() {
        return this.getDoubleValue(3);
    }

    @Override
    public double getRPM() {
        return this.getDoubleValue(2);
    }

    @Override
    public char getSource() {
        return this.getCharValue(0);
    }

    @Override
    public DataStatus getStatus() {
        return DataStatus.valueOf(this.getCharValue(4));
    }

    @Override
    public boolean isEngine() {
        return this.getCharValue(0) == 'E';
    }

    @Override
    public boolean isShaft() {
        return this.getCharValue(0) == 'S';
    }

    @Override
    public void setId(int id) {
        this.setIntValue(1, id);
    }

    @Override
    public void setPitch(double pitch) {
        this.setDoubleValue(3, pitch, 1, 1);
    }

    @Override
    public void setSource(char source) {
        if (source != 'E' && source != 'S') {
            throw new IllegalArgumentException("Invalid source indicator, expected 'E' or 'S'");
        }
        this.setCharValue(0, source);
    }

    @Override
    public void setStatus(DataStatus status) {
        this.setCharValue(4, status.toChar());
    }
}

