/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.orchestration;

import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.orchestration.CreateLoadBalancerMapping;
import com.sap.sse.landscape.orchestration.Procedure;
import java.util.concurrent.ExecutionException;

public class CreateDynamicLoadBalancerMapping<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
extends CreateLoadBalancerMapping<ShardingKey, MetricsT, ProcessT>
implements Procedure<ShardingKey> {
    public static <MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>, HostT extends AwsInstance<ShardingKey>, BuilderT extends Builder<BuilderT, CreateDynamicLoadBalancerMapping<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT>, ShardingKey> Builder<BuilderT, CreateDynamicLoadBalancerMapping<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT> builder() {
        return new BuilderImpl();
    }

    protected CreateDynamicLoadBalancerMapping(BuilderImpl<?, ShardingKey, MetricsT, ProcessT> builder) throws Exception {
        super(builder);
    }

    public static interface Builder<BuilderT extends Builder<BuilderT, T, ShardingKey, MetricsT, MasterProcessT>, T extends CreateDynamicLoadBalancerMapping<ShardingKey, MetricsT, MasterProcessT>, ShardingKey, MetricsT extends ApplicationProcessMetrics, MasterProcessT extends ApplicationProcess<ShardingKey, MetricsT, MasterProcessT>>
    extends CreateLoadBalancerMapping.Builder<BuilderT, T, ShardingKey, MetricsT, MasterProcessT> {
    }

    protected static class BuilderImpl<BuilderT extends Builder<BuilderT, CreateDynamicLoadBalancerMapping<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
    extends CreateLoadBalancerMapping.BuilderImpl<BuilderT, CreateDynamicLoadBalancerMapping<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT>
    implements Builder<BuilderT, CreateDynamicLoadBalancerMapping<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT> {
        protected BuilderImpl() {
        }

        @Override
        public ApplicationLoadBalancer<ShardingKey> getLoadBalancerUsed() throws InterruptedException, ExecutionException {
            ApplicationLoadBalancer result = super.getLoadBalancerUsed() != null ? super.getLoadBalancerUsed() : this.getOrCreateNonDNSMappedLoadBalancer(this.getProcess().getHost().getRegion(), this.getHostname(), (AwsLandscape<ShardingKey>)this.getLandscape());
            return result;
        }

        private ApplicationLoadBalancer<ShardingKey> getOrCreateNonDNSMappedLoadBalancer(Region region, String hostname, AwsLandscape<ShardingKey> landscape) throws InterruptedException, ExecutionException {
            ApplicationLoadBalancer<ShardingKey> result;
            String domainName = AwsLandscape.getHostedZoneName(hostname);
            ApplicationLoadBalancer<ShardingKey> existingLoadBalancer = landscape.getNonDNSMappedLoadBalancer(region, domainName);
            if (existingLoadBalancer != null) {
                result = existingLoadBalancer;
            } else {
                result = landscape.createNonDNSMappedLoadBalancer(region, domainName, this.getSecurityGroupForVpc());
                this.waitUntilLoadBalancerProvisioned(landscape, result);
                this.createWildcardRoute53Mapping(landscape, result, domainName);
            }
            return result;
        }

        private void createWildcardRoute53Mapping(AwsLandscape<ShardingKey> landscape, ApplicationLoadBalancer<ShardingKey> loadBalancer, String domainName) {
            String hostname = "*." + domainName;
            landscape.setDNSRecordToApplicationLoadBalancer(landscape.getDNSHostedZoneId(domainName), hostname, loadBalancer, false);
        }

        public CreateDynamicLoadBalancerMapping<ShardingKey, MetricsT, ProcessT> build() throws Exception {
            return new CreateDynamicLoadBalancerMapping(this);
        }
    }
}

