/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws;

import com.sap.sse.landscape.Host;
import com.sap.sse.landscape.aws.AwsAutoScalingGroup;
import com.sap.sse.landscape.aws.AwsAvailabilityZone;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.impl.AwsRegion;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceType;

public interface AwsInstance<ShardingKey>
extends Host {
    public static final String AWS_AUTOSCALING_GROUP_NAME_TAG = "aws:autoscaling:groupName";

    public AwsLandscape<ShardingKey> getLandscape();

    public String getInstanceId();

    public InstanceType getInstanceType();

    default public Instance getInstance() {
        return this.getLandscape().getInstance(this.getInstanceId(), this.getRegion());
    }

    public boolean isManagedByAutoScalingGroup();

    public boolean isManagedByAutoScalingGroup(Iterable<AwsAutoScalingGroup> var1);

    default public String getId() {
        return this.getInstanceId();
    }

    public void terminate();

    public AwsAvailabilityZone getAvailabilityZone();

    default public AwsRegion getRegion() {
        return (AwsRegion)super.getRegion();
    }

    public boolean verifySshKey(Optional<String> var1, byte[] var2);
}

