/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractEventOperation;
import com.sap.sse.common.TimePoint;
import com.sap.sse.shared.media.ImageDescriptor;
import com.sap.sse.shared.media.VideoDescriptor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class CreateEvent
extends AbstractEventOperation<Event> {
    private static final long serialVersionUID = 308389324918359960L;
    private final String venue;
    private final TimePoint startDate;
    private final TimePoint endDate;
    private final boolean isPublic;
    private final String eventName;
    private final String eventDescription;
    private final Iterable<ImageDescriptor> images;
    private final Iterable<VideoDescriptor> videos;
    private final URL officialWebsiteURL;
    private final URL baseURL;
    private final Map<Locale, URL> sailorsInfoWebsiteURLs;
    private final Iterable<UUID> leaderboardGroupIds;

    public CreateEvent(String eventName, String eventDescription, TimePoint startDate, TimePoint endDate, String venue, boolean isPublic, UUID id, URL officialWebsiteURL, URL baseURL, Map<Locale, URL> sailorsInfoWebsiteURLs, Iterable<ImageDescriptor> images, Iterable<VideoDescriptor> videos, Iterable<UUID> leaderboardGroupIds) {
        super(id);
        this.eventName = eventName;
        this.eventDescription = eventDescription;
        this.startDate = startDate;
        this.endDate = endDate;
        this.venue = venue;
        this.isPublic = isPublic;
        this.officialWebsiteURL = officialWebsiteURL;
        this.baseURL = baseURL;
        this.sailorsInfoWebsiteURLs = sailorsInfoWebsiteURLs;
        this.images = images;
        this.videos = videos;
        this.leaderboardGroupIds = leaderboardGroupIds;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }

    protected String getEventName() {
        return this.eventName;
    }

    public Event internalApplyTo(RacingEventService toState) {
        Event result = toState.createEventWithoutReplication(this.getEventName(), this.eventDescription, this.startDate, this.endDate, this.venue, this.isPublic, this.getId(), this.officialWebsiteURL, this.baseURL, this.sailorsInfoWebsiteURLs, this.images, this.videos);
        ArrayList<LeaderboardGroup> lgl = new ArrayList<LeaderboardGroup>();
        for (UUID lgid : this.leaderboardGroupIds) {
            LeaderboardGroup lg = toState.getLeaderboardGroupByID(lgid);
            if (lg == null) continue;
            lgl.add(lg);
        }
        result.setLeaderboardGroups(lgl);
        return result;
    }
}

