/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.WaypointOperation;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.logging.Logger;

public class AddWaypoint
extends WaypointOperation {
    private static final Logger logger = Logger.getLogger(AddWaypoint.class.getName());
    private static final long serialVersionUID = -1965390080325959255L;
    private final Iterable<Waypoint> waypointsBeforeAdd;

    public AddWaypoint(RegattaAndRaceIdentifier raceIdentifier, int zeroBasedIndex, Waypoint waypoint, Iterable<Waypoint> waypointsAfterAdd) {
        super(raceIdentifier, zeroBasedIndex, waypoint);
        ArrayList<Waypoint> waypointsBeforeAdd = new ArrayList<Waypoint>();
        for (Waypoint wp : waypointsAfterAdd) {
            if (wp == waypoint) continue;
            waypointsBeforeAdd.add(wp);
        }
        this.waypointsBeforeAdd = waypointsBeforeAdd;
    }

    public Void internalApplyTo(RacingEventService toState) throws Exception {
        boolean apply;
        RaceDefinition race = toState.getRace(this.getRaceIdentifier());
        Course course = race.getCourse();
        course.lockForRead();
        try {
            if (!Util.equals((Iterable)course.getWaypoints(), this.waypointsBeforeAdd)) {
                apply = false;
                logger.info("Not applying operation " + AddWaypoint.class.getName() + "(" + this.getZeroBasedIndex() + ", " + this.getWaypoint() + ") because the waypoint list " + this.waypointsBeforeAdd + " to which this operation was originally applied differs from the waypoint list " + course.getWaypoints() + " to which it would be applied now.");
            } else {
                apply = true;
            }
        }
        finally {
            course.unlockAfterRead();
        }
        if (apply) {
            course.addWaypoint(this.getZeroBasedIndex(), this.getWaypoint());
        }
        return null;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

