/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractLeaderboardColumnOperation;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;

public abstract class AbstractLeaderboardScoreCorrectionUpdate
extends AbstractLeaderboardColumnOperation<Util.Triple<Double, Double, Boolean>> {
    private static final long serialVersionUID = -977025759476022993L;
    private final String competitorIdAsString;
    private final TimePoint timePoint;

    public AbstractLeaderboardScoreCorrectionUpdate(String leaderboardName, String columnName, String competitorIdAsString, TimePoint timePoint) {
        super(leaderboardName, columnName);
        this.competitorIdAsString = competitorIdAsString;
        this.timePoint = timePoint;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }

    protected TimePoint getTimePoint() {
        return this.timePoint;
    }

    protected String getCompetitorIdAsString() {
        return this.competitorIdAsString;
    }

    public Util.Triple<Double, Double, Boolean> internalApplyTo(RacingEventService toState) throws NoWindException {
        Competitor competitor;
        Leaderboard leaderboard = toState.getLeaderboardByName(this.getLeaderboardName());
        if (leaderboard != null) {
            competitor = leaderboard.getCompetitorByIdAsString(this.competitorIdAsString);
            if (competitor == null) {
                throw new IllegalArgumentException("Didn't find competitor with ID " + this.competitorIdAsString + " in leaderboard " + this.getLeaderboardName());
            }
        } else {
            throw new IllegalArgumentException("Didn't find leaderboard " + this.getLeaderboardName());
        }
        RaceColumn raceColumn = leaderboard.getRaceColumnByName(this.getColumnName());
        Double newTotalPoints = this.updateScoreCorrection(leaderboard, competitor, raceColumn);
        Double newNetPoints = leaderboard.getEntry(competitor, raceColumn, this.getTimePoint()).getNetPoints();
        boolean isScoreCorrected = leaderboard.getScoreCorrection().isScoreCorrected(competitor, raceColumn, this.getTimePoint());
        this.updateStoredLeaderboard(toState, leaderboard);
        return new Util.Triple((Object)newTotalPoints, (Object)newNetPoints, (Object)isScoreCorrected);
    }

    protected abstract Double updateScoreCorrection(Leaderboard var1, Competitor var2, RaceColumn var3);
}

