/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.orc.impl;

import com.sap.sailing.domain.common.orc.ORCPerformanceCurveCourse;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLeg;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLegTypes;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.function.BiFunction;

public class ORCPerformanceCurveCourseImpl
implements ORCPerformanceCurveCourse {
    private static final long serialVersionUID = -8975425405727779768L;
    private final Iterable<ORCPerformanceCurveLeg> legs;

    public ORCPerformanceCurveCourseImpl(Iterable<ORCPerformanceCurveLeg> legs) {
        this.legs = legs;
    }

    @Override
    public Iterable<ORCPerformanceCurveLeg> getLegs() {
        return this.legs;
    }

    @Override
    public ORCPerformanceCurveCourse subcourse(int lastFinishedLegOneBased, double shareOfCurrentLeg) {
        return this.subcourse(lastFinishedLegOneBased, shareOfCurrentLeg, null);
    }

    @Override
    public ORCPerformanceCurveCourse subcourse(int lastFinishedLegOneBased, double shareOfCurrentLeg, BiFunction<Integer, ORCPerformanceCurveLeg, ORCPerformanceCurveLeg> windwardLeewardLegReplacer) {
        if (lastFinishedLegOneBased >= Util.size(this.legs)) {
            return this;
        }
        ArrayList<ORCPerformanceCurveLeg> resultLegs = new ArrayList<ORCPerformanceCurveLeg>();
        int count = 0;
        ORCPerformanceCurveLeg lastFinishedLeg = null;
        for (ORCPerformanceCurveLeg leg : this.getLegs()) {
            ORCPerformanceCurveLeg potentiallyReplacedLeg = leg.getType() == ORCPerformanceCurveLegTypes.WINDWARD_LEEWARD_REAL_LIVE && windwardLeewardLegReplacer != null ? windwardLeewardLegReplacer.apply(count, leg) : leg;
            if (count++ >= lastFinishedLegOneBased) {
                lastFinishedLeg = potentiallyReplacedLeg;
                break;
            }
            resultLegs.add(potentiallyReplacedLeg);
        }
        if (shareOfCurrentLeg > 0.0) {
            resultLegs.add(lastFinishedLeg.scale(shareOfCurrentLeg));
        }
        return new ORCPerformanceCurveCourseImpl(resultLegs);
    }

    public String toString() {
        return "[legs=" + this.legs + ", totalLength=" + this.getTotalLength().getNauticalMiles() + "NM]";
    }
}

