/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.impl;

import com.sap.sailing.domain.common.NonCardinalBounds;
import com.sap.sailing.domain.common.Position;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;

public class NonCardinalBoundsImpl
implements NonCardinalBounds {
    private static final double EPSILON = 0.001;
    private final Position lowerLeft;
    private final Bearing verticalBearing;
    private final Distance verticalSize;
    private final Distance horizontalSize;

    public NonCardinalBoundsImpl(Position lowerLeft, Bearing verticalBearing, Distance verticalSize, Distance horizontalSize) {
        this.lowerLeft = lowerLeft;
        this.verticalBearing = verticalBearing;
        this.verticalSize = verticalSize;
        this.horizontalSize = horizontalSize;
    }

    @Override
    public Position getLowerLeft() {
        return this.lowerLeft;
    }

    @Override
    public Distance getVerticalSize() {
        return this.verticalSize;
    }

    @Override
    public Distance getHorizontalSize() {
        return this.horizontalSize;
    }

    @Override
    public NonCardinalBounds extend(Position p) {
        NonCardinalBounds result;
        if (this.contains(p)) {
            result = this;
        } else {
            Position newLowerLeft = this.getLowerLeft();
            Distance newVerticalSize = this.getVerticalSize();
            Distance newHorizontalSize = this.getHorizontalSize();
            Distance horizontalDistanceFromLeft = p.crossTrackError(this.getLowerLeft(), this.getVerticalBearing());
            if (horizontalDistanceFromLeft.compareTo((Object)Distance.NULL) < 0) {
                Distance verticalDistanceToBottom = p.crossTrackError(this.getLowerLeft(), this.getHorizontalBearing());
                newLowerLeft = p.translateGreatCircle(this.getVerticalBearing(), verticalDistanceToBottom);
                newHorizontalSize = this.getHorizontalSize().add(horizontalDistanceFromLeft.scale(-1.0));
            } else {
                Distance horizontalDistanceFromRight = p.crossTrackError(this.getLowerRight(), this.getVerticalBearing());
                if (horizontalDistanceFromRight.compareTo((Object)Distance.NULL) > 0) {
                    newHorizontalSize = this.getHorizontalSize().add(horizontalDistanceFromRight);
                }
            }
            Distance verticalDistanceFromBottom = p.crossTrackError(this.getLowerLeft(), this.getHorizontalBearing());
            if (verticalDistanceFromBottom.compareTo((Object)Distance.NULL) > 0) {
                Distance horizontalDistanceToLeft = p.crossTrackError(newLowerLeft, this.getVerticalBearing());
                newLowerLeft = p.translateGreatCircle(this.getHorizontalBearing().reverse(), horizontalDistanceToLeft);
                newVerticalSize = this.getVerticalSize().add(verticalDistanceFromBottom);
            } else {
                Position newUppperLeft = newLowerLeft.translateGreatCircle(this.getVerticalBearing(), newVerticalSize);
                Distance verticalDistanceFromTop = p.crossTrackError(newUppperLeft, this.getHorizontalBearing());
                if (verticalDistanceFromTop.compareTo((Object)Distance.NULL) < 0) {
                    newVerticalSize = this.getVerticalSize().add(verticalDistanceFromTop.scale(-1.0));
                }
            }
            result = NonCardinalBounds.create(newLowerLeft, this.getVerticalBearing(), newVerticalSize, newHorizontalSize);
        }
        assert (result.contains(p));
        return result;
    }

    @Override
    public NonCardinalBounds extend(NonCardinalBounds other) {
        assert (this.contains(this.getLowerLeft()));
        assert (this.contains(this.getLowerRight()));
        assert (this.contains(this.getUpperLeft()));
        assert (this.contains(this.getUpperRight()));
        NonCardinalBounds result = this.extend(other.getLowerLeft()).extend(other.getLowerRight()).extend(other.getUpperLeft()).extend(other.getUpperRight());
        assert (result.contains(this.getLowerLeft()));
        assert (result.contains(this.getLowerRight()));
        assert (result.contains(this.getUpperLeft()));
        assert (result.contains(this.getUpperRight()));
        assert (result.contains(other.getLowerLeft()));
        assert (result.contains(other.getLowerRight()));
        assert (result.contains(other.getUpperLeft()));
        assert (result.contains(other.getUpperRight()));
        return result;
    }

    @Override
    public boolean contains(Position p) {
        return p.crossTrackError(this.getLowerLeft(), this.getVerticalBearing()).compareTo((Object)this.getVerticalSize().scale(-0.001)) >= 0 && p.crossTrackError(this.getLowerLeft(), this.getHorizontalBearing()).compareTo((Object)this.getHorizontalSize().scale(0.001)) <= 0 && p.crossTrackError(this.getUpperLeft(), this.getHorizontalBearing()).compareTo((Object)this.getHorizontalSize().scale(-0.001)) >= 0 && p.crossTrackError(this.getLowerRight(), this.getVerticalBearing()).compareTo((Object)this.getVerticalSize().scale(0.001)) <= 0;
    }

    @Override
    public boolean contains(NonCardinalBounds other) {
        return this.contains(other.getLowerLeft()) && this.contains(other.getUpperLeft()) && this.contains(other.getUpperRight()) && this.contains(other.getLowerRight());
    }

    @Override
    public Bearing getVerticalBearing() {
        return this.verticalBearing;
    }

    @Override
    public Position getCenter() {
        return this.getLowerLeft().translateGreatCircle(this.getLowerLeft().getBearingGreatCircle(this.getUpperRight()), this.getLowerLeft().getDistance(this.getUpperRight()).scale(0.5));
    }

    public String toString() {
        return "NonCardinalBounds[lowerLeft=" + this.lowerLeft + ", verticalBearing=" + this.verticalBearing + ", verticalSize=" + this.verticalSize + ", horizontalSize=" + this.horizontalSize + "]";
    }
}

