/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.windfield.impl;

import com.sap.sailing.domain.base.impl.KilometersPerHourSpeedWithBearingImpl;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.simulator.Grid;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.TimedPosition;
import com.sap.sailing.simulator.TimedPositionWithSpeed;
import com.sap.sailing.simulator.impl.PathImpl;
import com.sap.sailing.simulator.impl.TimedPositionImpl;
import com.sap.sailing.simulator.impl.TimedPositionWithSpeedImpl;
import com.sap.sailing.simulator.windfield.WindControlParameters;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;

public abstract class WindFieldGeneratorImpl
implements WindFieldGenerator {
    private static final long serialVersionUID = -6366698648104363491L;
    protected Grid boundary;
    protected WindControlParameters windParameters;
    protected Position[][] positions;
    protected Map<TimePoint, SpeedWithBearing[][]> timeSpeedWithBearingMap;
    protected TimePoint startTime;
    protected TimePoint endTime;
    protected int[] gridRes;
    protected Position[] gridAreaGps;
    protected Duration timeStep;
    private static Logger logger = Logger.getLogger("com.sap.sailing.windfield");

    public WindFieldGeneratorImpl(Grid boundary, WindControlParameters windParameters) {
        this.boundary = boundary;
        this.windParameters = windParameters;
        this.positions = null;
    }

    @Override
    public WindControlParameters getWindParameters() {
        return this.windParameters;
    }

    @Override
    public void setBoundary(Grid boundary) {
        this.boundary = boundary;
    }

    @Override
    public Wind getWind(TimedPosition coordinates) {
        KnotSpeedImpl knotSpeedImpl = new KnotSpeedImpl(this.windParameters.baseWindSpeed.doubleValue());
        double wBearing = this.windParameters.baseWindBearing * (1.0 + coordinates.getPosition().getDistance(this.boundary.getCorners().get("NorthWest")).getMeters() / this.boundary.getHeight().getMeters());
        KilometersPerHourSpeedWithBearingImpl wspeed = new KilometersPerHourSpeedWithBearingImpl(knotSpeedImpl.getKilometersPerHour(), (Bearing)new DegreeBearingImpl(wBearing));
        return new WindImpl(coordinates.getPosition(), coordinates.getTimePoint(), (SpeedWithBearing)wspeed);
    }

    @Override
    public Grid getGrid() {
        return this.boundary;
    }

    @Override
    public Position[][] getPositionGrid() {
        return this.positions;
    }

    @Override
    public Path getLine(TimedPosition seed, boolean forward) {
        long timeStep = 10000L;
        TimePoint currentTime = seed.getTimePoint();
        TimePoint startTime = seed.getTimePoint();
        Position currentPosition = seed.getPosition();
        LinkedList<TimedPositionWithSpeed> path = new LinkedList<TimedPositionWithSpeed>();
        path.add(new TimedPositionWithSpeedImpl(currentTime, currentPosition, null));
        while (this.boundary.inBounds(currentPosition)) {
            Wind currentWind = this.getWind(new TimedPositionImpl(startTime, currentPosition));
            TimePoint middleTime = currentTime.plus(timeStep / 2L);
            Position middlePosition = !forward ? currentWind.travelTo(currentPosition, middleTime, currentTime) : currentWind.travelTo(currentPosition, currentTime, middleTime);
            Wind middleWind = this.getWind(new TimedPositionImpl(startTime, middlePosition));
            TimePoint nextTime = currentTime.plus(timeStep);
            Position nextPosition = !forward ? middleWind.travelTo(currentPosition, nextTime, currentTime) : middleWind.travelTo(currentPosition, currentTime, nextTime);
            path.add(new TimedPositionWithSpeedImpl(nextTime, nextPosition, null));
            currentTime = nextTime;
            currentPosition = nextPosition;
        }
        logger.info("Added wind line with " + path.size() + "points");
        return new PathImpl(path, this, false);
    }

    @Override
    public void setPositionGrid(Position[][] positions) {
        this.positions = positions;
    }

    public Position getPosition(int i, int j) {
        return this.positions[i][j];
    }

    public Util.Pair<Integer, Integer> getPositionIndex(Position p) {
        Util.Pair<Integer, Integer> gIdx = this.boundary.getIndex(p);
        if (gIdx.getA() != null && gIdx.getB() != null) {
            return gIdx;
        }
        return null;
    }

    public int getTimeIndex(TimePoint t) {
        return (int)((t.asMillis() - this.startTime.asMillis()) / this.timeStep.asMillis());
    }

    @Override
    public void generate(TimePoint start, TimePoint end, Duration step) {
        this.startTime = start;
        this.endTime = end;
        this.timeStep = step;
    }

    @Override
    public TimePoint getStartTime() {
        return this.startTime;
    }

    @Override
    public Duration getTimeStep() {
        return this.timeStep;
    }

    @Override
    public TimePoint getEndTime() {
        return this.endTime;
    }

    @Override
    public int[] getGridResolution() {
        return this.gridRes;
    }

    @Override
    public void setGridResolution(int[] gridRes) {
        this.gridRes = gridRes;
    }

    @Override
    public Position[] getGridAreaGps() {
        return this.gridAreaGps;
    }

    @Override
    public void setGridAreaGps(Position[] gridAreaGps) {
        this.gridAreaGps = gridAreaGps;
    }
}

