/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.simulator.Grid;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Util;
import java.util.HashMap;
import java.util.Map;

public class RectangularGrid
implements Grid {
    private static final long serialVersionUID = 3598121983120213464L;
    private Position rcStart;
    private Position rcEnd;
    private double lngScale;
    private double[] nvVrt;
    private double[] nvHor;
    private int vPoints;
    private int hPoints;
    private int borderY;
    private int borderX;
    private Position northWest;
    private Position southWest;
    private Position northEast;
    private Position appNorthWest;
    private Position appSouthEast;
    private Position appSouthWest;
    private Position appNorthEast;
    private Bearing north;
    private Bearing south;
    private Bearing east;
    private Bearing west;
    private Distance appWidth;
    private Distance appHeight;
    double tolerance;

    public RectangularGrid(Position p1, Position p2) {
        this.rcStart = p1;
        this.rcEnd = p2;
        this.tolerance = 0.1;
        this.north = p1.getBearingGreatCircle(p2);
        this.south = this.north.reverse();
        this.east = this.north.add(relativeEast);
        this.west = this.north.add(relativeWest);
        this.appHeight = p1.getDistance(p2);
        this.appWidth = this.appHeight.scale(2.0);
        this.appNorthWest = p2.translateGreatCircle(this.west, this.appHeight);
        this.appNorthEast = p2.translateGreatCircle(this.east, this.appHeight);
        this.appSouthWest = p1.translateGreatCircle(this.west, this.appHeight);
        this.appSouthEast = p1.translateGreatCircle(this.east, this.appHeight);
        Distance diag = this.appNorthWest.getDistance(this.appSouthEast);
        Bearing diag1 = this.appSouthEast.getBearingGreatCircle(this.appNorthWest);
        this.northWest = this.appNorthWest.translateGreatCircle(diag1, diag.scale(this.tolerance));
        Bearing diag2 = this.appSouthWest.getBearingGreatCircle(this.appNorthEast);
        this.northEast = this.appNorthEast.translateGreatCircle(diag2, diag.scale(this.tolerance));
        diag2 = diag2.reverse();
        this.southWest = this.appSouthWest.translateGreatCircle(diag2, diag.scale(this.tolerance));
    }

    @Override
    public Map<String, Position> getCorners() {
        HashMap<String, Position> map = new HashMap<String, Position>();
        map.put("NorthWest", this.appNorthWest);
        map.put("SouthWest", this.appSouthWest);
        map.put("SouthEast", this.appSouthEast);
        map.put("NorthEast", this.appNorthEast);
        return map;
    }

    @Override
    public boolean inBounds(Position p) {
        Position northProjection = p.projectToLineThrough(this.northWest, this.getEast());
        Position southProjection = p.projectToLineThrough(this.southWest, this.getEast());
        Position westProjection = p.projectToLineThrough(this.northWest, this.getNorth());
        Position eastProjection = p.projectToLineThrough(this.northEast, this.getNorth());
        Distance northSouth = northProjection.getDistance(southProjection);
        Distance eastWest = eastProjection.getDistance(westProjection);
        return northSouth.compareTo((Object)p.getDistance(northProjection)) >= 0 && northSouth.compareTo((Object)p.getDistance(southProjection)) >= 0 && eastWest.compareTo((Object)p.getDistance(eastProjection)) >= 0 && eastWest.compareTo((Object)p.getDistance(westProjection)) >= 0;
    }

    @Override
    public Position[][] generatePositions(int hPoints, int vPoints, int borderY, int borderX) {
        this.vPoints = vPoints;
        this.hPoints = hPoints;
        this.borderY = borderY;
        this.borderX = borderX;
        double xscale = 1.5;
        double alat = (this.rcEnd.getLatDeg() + this.rcStart.getLatDeg()) / 2.0;
        this.lngScale = Math.cos(alat * Math.PI / 180.0);
        double[] dVrt = new double[]{this.rcEnd.getLatDeg() - this.rcStart.getLatDeg(), this.rcEnd.getLngDeg() - this.rcStart.getLngDeg()};
        double[] dscVrt = new double[]{dVrt[0], dVrt[1] * this.lngScale};
        double lscVrt = Math.sqrt(dscVrt[0] * dscVrt[0] + dscVrt[1] * dscVrt[1]);
        this.nvVrt = new double[2];
        this.nvVrt[0] = dscVrt[0] / lscVrt / lscVrt * (double)(vPoints - 1);
        this.nvVrt[1] = dscVrt[1] / lscVrt / lscVrt * (double)(vPoints - 1);
        double[] nscHor = new double[]{-dscVrt[1] / lscVrt, dscVrt[0] / lscVrt};
        this.nvHor = new double[2];
        this.nvHor[0] = nscHor[0] / xscale / lscVrt * (double)(hPoints - 1);
        this.nvHor[1] = nscHor[1] / xscale / lscVrt * (double)(hPoints - 1);
        double[] nHor = new double[]{nscHor[0], nscHor[1] / this.lngScale};
        Position[][] grid = new Position[vPoints + 2 * borderY][hPoints + 2 * borderX];
        int i = -borderY;
        while (i < vPoints + borderY) {
            Object pv = i == 0 ? this.rcStart : (i == vPoints - 1 ? this.rcEnd : new DegreePosition(this.rcStart.getLatDeg() + (double)i / ((double)vPoints - 1.0) * dVrt[0], this.rcStart.getLngDeg() + (double)i / ((double)vPoints - 1.0) * dVrt[1]));
            int j = 0;
            while (j < (hPoints + 2 * borderX) / 2) {
                grid[i + borderY][j] = new DegreePosition(pv.getLatDeg() - ((double)(hPoints + 2 * borderX - 1) / 2.0 - (double)j) / (double)(hPoints - 1) * nHor[0] * xscale * lscVrt, pv.getLngDeg() - ((double)(hPoints + 2 * borderX - 1) / 2.0 - (double)j) / (double)(hPoints - 1) * nHor[1] * xscale * lscVrt);
                ++j;
            }
            if ((hPoints + 2 * borderX) % 2 == 1) {
                grid[i + borderY][j] = pv;
                ++j;
            }
            while (j < hPoints + 2 * borderX) {
                grid[i + borderY][j] = new DegreePosition(pv.getLatDeg() + ((double)j - (double)(hPoints + 2 * borderX - 1) / 2.0) / (double)(hPoints - 1) * nHor[0] * xscale * lscVrt, pv.getLngDeg() + ((double)j - (double)(hPoints + 2 * borderX - 1) / 2.0) / (double)(hPoints - 1) * nHor[1] * xscale * lscVrt);
                ++j;
            }
            ++i;
        }
        return grid;
    }

    @Override
    public Util.Pair<Integer, Integer> getIndex(Position x) {
        double[] scX = new double[]{x.getLatDeg() - this.rcStart.getLatDeg(), (x.getLngDeg() - this.rcStart.getLngDeg()) * this.lngScale};
        double sPrd = scX[0] * this.nvHor[0] + scX[1] * this.nvHor[1];
        int vIdx = Math.min(Math.max(-this.borderY, (int)Math.round(scX[0] * this.nvVrt[0] + scX[1] * this.nvVrt[1])), this.vPoints - 1 + this.borderY);
        int hIdx = Math.min(Math.max(-this.borderX, (int)Math.round(sPrd + (double)(this.hPoints - 1) / 2.0)), this.hPoints - 1 + this.borderX);
        return new Util.Pair((Object)vIdx, (Object)hIdx);
    }

    @Override
    public int getResY() {
        return this.vPoints;
    }

    @Override
    public int getResX() {
        return this.hPoints;
    }

    @Override
    public int getBorderY() {
        return this.borderY;
    }

    @Override
    public int getBorderX() {
        return this.borderX;
    }

    @Override
    public Bearing getNorth() {
        return this.north;
    }

    @Override
    public Bearing getSouth() {
        return this.south;
    }

    @Override
    public Bearing getEast() {
        return this.east;
    }

    @Override
    public Bearing getWest() {
        return this.west;
    }

    @Override
    public Distance getWidth() {
        return this.appWidth;
    }

    @Override
    public Distance getHeight() {
        return this.appHeight;
    }
}

