/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.premium;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.Image;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PremiumIconRessource;

public abstract class PremiumUiElement
extends Composite
implements HasEnabled {
    protected final HasPermissions.Action action;
    protected final PaywallResolver paywallResolver;
    protected final SecuredDTO contextDTO;
    private boolean enabled = true;

    protected PremiumUiElement(HasPermissions.Action action, PaywallResolver paywallResolver, SecuredDTO contextDTO) {
        this.action = action;
        this.paywallResolver = paywallResolver;
        this.contextDTO = contextDTO;
        paywallResolver.registerUserStatusEventHandler((user, preAuth) -> this.updateUserPermission());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected final boolean hasPermission() {
        return this.paywallResolver.hasPermission(this.action, this.contextDTO);
    }

    protected final void updateUserPermission() {
        this.onUserPermissionUpdate(this.hasPermission());
    }

    protected abstract void onUserPermissionUpdate(boolean var1);

    protected Image createPremiumIcon() {
        return new Image(PremiumIconRessource.INSTANCE.premiumIcon().getSafeUri());
    }
}

