/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.premium;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.subscription.InvalidSubscriptionProviderException;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.subscription.SubscriptionServiceFactory;
import com.sap.sse.security.ui.client.subscription.SubscriptionWriteServiceAsync;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PaywallResolverImpl
implements PaywallResolver {
    private static Logger LOG = Logger.getLogger(PaywallResolverImpl.class.getName());
    private final UserService userService;
    private final SubscriptionServiceFactory subscriptionServiceFactory;

    public PaywallResolverImpl(UserService userService, SubscriptionServiceFactory subscriptionServiceFactory) {
        this.userService = userService;
        this.subscriptionServiceFactory = subscriptionServiceFactory;
    }

    public void getUnlockingSubscriptionPlans(HasPermissions.Action action, SecuredDTO dtoContext, Consumer<List<String>> callback) {
        WildcardPermission permission = dtoContext == null ? WildcardPermission.builder().withActions(new HasPermissions.Action[]{action}).build() : dtoContext.getIdentifier().getPermission(action);
        SubscriptionWriteServiceAsync subscriptionWriteService = this.getSubscriptionWriteService();
        if (subscriptionWriteService != null) {
            subscriptionWriteService.getUnlockingSubscriptionplans(permission, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            LOG.warning("Unable to determine subscription plans unlocking action " + action.name() + ". No SubscriptionWriteService found.");
        }
    }

    public boolean hasPermission(HasPermissions.Action action, SecuredDTO dtoContext) {
        if (this.userService != null) {
            if (action != null) {
                return this.userService.hasPermission(dtoContext, action);
            }
            return this.userService.hasPermission(dtoContext, (HasPermissions.Action)HasPermissions.DefaultActions.READ);
        }
        return false;
    }

    public Map<HasPermissions.Action, Boolean> getHasPermissionMap(Set<HasPermissions.Action> premiumActions, SecuredDTO dtoContext) {
        HashMap<HasPermissions.Action, Boolean> premiumPermissions = new HashMap<HasPermissions.Action, Boolean>();
        for (HasPermissions.Action premiumAction : premiumActions) {
            premiumPermissions.put(premiumAction, this.hasPermission(premiumAction, dtoContext));
        }
        return premiumPermissions;
    }

    public HandlerRegistration registerUserStatusEventHandler(UserStatusEventHandler handler) {
        if (this.userService != null) {
            this.userService.addUserStatusEventHandler(handler);
            return () -> this.userService.removeUserStatusEventHandler(handler);
        }
        LOG.log(Level.SEVERE, "No Userservice set. Could not add UserStatusEventHandler");
        return null;
    }

    private SubscriptionWriteServiceAsync<?, ?, ?> getSubscriptionWriteService() {
        try {
            return this.subscriptionServiceFactory.getDefaultWriteAsyncService();
        }
        catch (InvalidSubscriptionProviderException e) {
            LOG.log(Level.SEVERE, "An invalid subscription provider exception occured while getting the SubscriptionWriteSerivce.", e);
            return null;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "No SubscriptionServiceFactory set.", e);
            return null;
        }
    }

    static /* synthetic */ Logger access$0() {
        return LOG;
    }
}

