/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.component;

import com.sap.sse.security.ui.client.i18n.StringMessages;

public class NewAccountValidator {
    private static final int MINIMUM_USERNAME_LENGTH = 3;
    private static final int MINIMUM_PASSWORD_LENGTH = 5;
    protected final StringMessages stringMessages;

    public NewAccountValidator(StringMessages stringMessages) {
        this.stringMessages = stringMessages;
    }

    public String validateUsernameAndPassword(String username, String password, String passwordRepeat, boolean reallyUseLeadingOrTrailingSpacesInUsername) {
        String result = this.validateUsername(username, reallyUseLeadingOrTrailingSpacesInUsername);
        if (result == null) {
            result = this.validatePasswords(password, passwordRepeat);
        }
        return result;
    }

    private String validatePasswords(String password, String passwordRepeat) {
        String result = password == null || password.length() < 5 ? this.stringMessages.passwordMustHaveAtLeastNCharacters(5) : (!password.equals(passwordRepeat) ? this.stringMessages.passwordsDontMatch() : null);
        return result;
    }

    protected String validateUsername(String username, boolean tolerateLeadingOrTrailingSpacesInUsername) {
        String result = username == null || username.length() < 3 ? this.stringMessages.usernameMustHaveAtLeastNCharacters(3) : ((username.startsWith(" ") || username.endsWith(" ")) && !tolerateLeadingOrTrailingSpacesInUsername ? this.stringMessages.usernameShouldNotStartOrEndWithSpaceCharactersUnlessYouExplicitlyWantTo() : null);
        return result;
    }
}

