/*
 * Decompiled with CFR 0.152.
 */
package smile.projection;

import java.io.Serializable;
import smile.math.Math;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;
import smile.projection.Projection;
import smile.stat.distribution.GaussianDistribution;

public class RandomProjection
implements Projection<double[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double[] prob = new double[]{0.16666666666666666, 0.6666666666666666, 0.16666666666666666};
    private int p;
    private int n;
    private DenseMatrix projection;

    public RandomProjection(int n, int p) {
        this(n, p, false);
    }

    public RandomProjection(int n, int p, boolean sparse) {
        if (n < 2) {
            throw new IllegalArgumentException("Invalid dimension of input space: " + n);
        }
        if (p < 1 || p > n) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + p);
        }
        this.n = n;
        this.p = p;
        if (sparse) {
            this.projection = Matrix.zeros((int)p, (int)n);
            double scale = Math.sqrt((double)3.0);
            for (int i = 0; i < p; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.projection.set(i, j, scale * (double)(Math.random((double[])prob) - 1));
                }
            }
        } else {
            int j;
            int i;
            double[][] proj = new double[p][n];
            GaussianDistribution gauss = GaussianDistribution.getInstance();
            for (i = 0; i < p; ++i) {
                for (j = 0; j < n; ++j) {
                    proj[i][j] = gauss.rand();
                }
            }
            Math.unitize((double[])proj[0]);
            for (i = 1; i < p; ++i) {
                for (j = 0; j < i; ++j) {
                    double t = -Math.dot((double[])proj[i], (double[])proj[j]);
                    Math.axpy((double)t, (double[])proj[j], (double[])proj[i]);
                }
                Math.unitize((double[])proj[i]);
            }
            this.projection = Matrix.newInstance((double[][])proj);
        }
    }

    public DenseMatrix getProjection() {
        return this.projection;
    }

    @Override
    public double[] project(double[] x) {
        if (x.length != this.n) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.n));
        }
        double[] y = new double[this.p];
        this.projection.ax(x, y);
        return y;
    }

    public double[][] project(double[][] x) {
        if (x[0].length != this.n) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x[0].length, this.n));
        }
        double[][] y = new double[x.length][this.p];
        for (int i = 0; i < x.length; ++i) {
            this.projection.ax(x[i], y[i]);
        }
        return y;
    }
}

