/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.persistence.impl;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.persistence.MongoRaceLogStoreFactory;
import com.sap.sailing.domain.persistence.MongoRegattaLogStoreFactory;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParametersHandler;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.sap.sailing.domain.tractracadapter.TracTracAdapterFactory;
import com.sap.sailing.domain.tractracadapter.TracTracConfiguration;
import com.sap.sailing.domain.tractracadapter.persistence.DomainObjectFactory;
import com.sap.sailing.domain.tractracadapter.persistence.MongoObjectFactory;
import com.sap.sailing.domain.tractracadapter.persistence.PersistenceFactory;
import com.sap.sailing.domain.tractracadapter.persistence.impl.CollectionNames;
import com.sap.sailing.domain.tractracadapter.persistence.impl.TracTracConnectivityParamsHandler;
import com.sap.sse.mongodb.MongoDBService;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.util.ClearStateTestSupport;
import com.sap.sse.util.ServiceTrackerFactory;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());

    public void start(BundleContext context) throws Exception {
        CollectionNames[] collectionNamesArray = CollectionNames.values();
        int n = collectionNamesArray.length;
        int n2 = 0;
        while (n2 < n) {
            CollectionNames name = collectionNamesArray[n2];
            MongoDBService.INSTANCE.registerExclusively(CollectionNames.class, name.name());
            ++n2;
        }
        new Thread(() -> {
            ServiceTracker mongoObjectFactoryServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, com.sap.sailing.domain.persistence.MongoObjectFactory.class);
            ServiceTracker domainObjectFactoryServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, com.sap.sailing.domain.persistence.DomainObjectFactory.class);
            FullyInitializedReplicableTracker securityServiceServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, SecurityService.class);
            ServiceTracker tractracAdapterFactoryTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, TracTracAdapterFactory.class);
            try {
                com.sap.sailing.domain.persistence.MongoObjectFactory mongoObjectFactory = (com.sap.sailing.domain.persistence.MongoObjectFactory)mongoObjectFactoryServiceTracker.waitForService(0L);
                com.sap.sailing.domain.persistence.DomainObjectFactory domainObjectFactory = (com.sap.sailing.domain.persistence.DomainObjectFactory)domainObjectFactoryServiceTracker.waitForService(0L);
                SecurityService securityService = (SecurityService)securityServiceServiceTracker.getInitializedService(0L);
                TracTracAdapterFactory tractracAdapterFactory = (TracTracAdapterFactory)tractracAdapterFactoryTracker.waitForService(0L);
                Hashtable<String, String> properties = new Hashtable<String, String>();
                DomainFactory domainFactory = tractracAdapterFactory.getOrCreateTracTracAdapter(domainObjectFactory.getBaseDomainFactory()).getTracTracDomainFactory();
                DomainObjectFactory tractracDomainObjectFactory = PersistenceFactory.INSTANCE.createDomainObjectFactory(mongoObjectFactory.getDatabase(), domainFactory);
                final MongoObjectFactory tractracMongoObjectFactory = PersistenceFactory.INSTANCE.createMongoObjectFactory(mongoObjectFactory.getDatabase());
                TracTracConnectivityParamsHandler paramsHandler = new TracTracConnectivityParamsHandler(MongoRaceLogStoreFactory.INSTANCE.getMongoRaceLogStore(mongoObjectFactory, domainObjectFactory), MongoRegattaLogStoreFactory.INSTANCE.getMongoRegattaLogStore(mongoObjectFactory, domainObjectFactory), domainFactory, tractracMongoObjectFactory, securityService);
                for (TracTracConfiguration trackTrackConfig : tractracDomainObjectFactory.getTracTracConfigurations()) {
                    securityService.migrateOwnership((WithQualifiedObjectIdentifier)trackTrackConfig);
                }
                securityService.assumeOwnershipMigrated(SecuredDomainType.TRACTRAC_ACCOUNT.getName());
                ((Dictionary)properties).put("type", "TRAC_TRAC");
                context.registerService(RaceTrackingConnectivityParametersHandler.class, (Object)paramsHandler, properties);
                context.registerService(ClearStateTestSupport.class.getName(), (Object)new ClearStateTestSupport(){

                    public void clearState() throws Exception {
                        tractracMongoObjectFactory.clear();
                    }
                }, null);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception trying to register TracTrac RaceTrackingConnectivityParametersHandler implementation", e);
            }
        }, String.valueOf(this.getClass().getName()) + " registering connectivity handler").start();
    }

    public void stop(BundleContext context) throws Exception {
    }
}

