/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.udpconnector;

import com.sap.sailing.udpconnector.UDPMessage;
import com.sap.sailing.udpconnector.UDPMessageListener;
import com.sap.sailing.udpconnector.UDPMessageParser;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class UDPReceiver<MessageType extends UDPMessage, ListenerType extends UDPMessageListener<MessageType>>
implements Runnable {
    private static final Logger logger = Logger.getLogger(UDPReceiver.class.getName());
    private boolean stopped = false;
    private final int listeningOnPort;
    private final DatagramSocket udpSocket;
    private ToListenerDispatcher dispatchingToListenersThread;
    private final ConcurrentMap<ListenerType, Boolean> listeners;
    private static final int MAX_PACKET_SIZE = 65536;

    public UDPReceiver(int listeningOnPort) throws SocketException {
        this.udpSocket = listeningOnPort == 0 ? new DatagramSocket() : new DatagramSocket(listeningOnPort);
        this.listeners = new ConcurrentHashMap<ListenerType, Boolean>();
        this.listeningOnPort = this.udpSocket.getLocalPort();
        this.dispatchingToListenersThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws SocketException, IOException {
        this.stopped = true;
        UDPReceiver uDPReceiver = this;
        synchronized (uDPReceiver) {
            if (this.dispatchingToListenersThread != null) {
                this.dispatchingToListenersThread.halt();
            }
        }
        byte[] buf = new byte[]{};
        DatagramPacket stopPacket = new DatagramPacket(buf, 0, InetAddress.getLocalHost(), this.listeningOnPort);
        DatagramSocket stopper = new DatagramSocket();
        stopper.send(stopPacket);
        stopper.close();
        if (!this.udpSocket.isConnected()) {
            this.udpSocket.close();
        }
    }

    public synchronized boolean stopIfNoListeners() throws SocketException, IOException {
        boolean result = this.listeners.isEmpty();
        if (result) {
            this.stop();
        }
        return result;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] buf = new byte[65536];
        DatagramPacket p = new DatagramPacket(buf, buf.length);
        while (!this.stopped) {
            try {
                UDPMessage msg;
                this.udpSocket.receive(p);
                if (p.getLength() <= 0 || (msg = (UDPMessage)this.getParser().parse(p)) == null) continue;
                UDPReceiver uDPReceiver = this;
                synchronized (uDPReceiver) {
                    if (this.dispatchingToListenersThread != null) {
                        this.dispatchingToListenersThread.dispatch(msg);
                    }
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Exception while receiving UDP packet", e);
            }
        }
        logger.info("Closing UDP socket on port " + this.udpSocket.getLocalPort());
        this.udpSocket.close();
        if (this.udpSocket.isConnected()) {
            this.udpSocket.disconnect();
        }
    }

    public synchronized void addListener(ListenerType listener, boolean validMessagesOnly) {
        this.listeners.put(listener, validMessagesOnly);
        if (this.dispatchingToListenersThread == null) {
            this.dispatchingToListenersThread = new ToListenerDispatcher();
            this.dispatchingToListenersThread.setDaemon(true);
            this.dispatchingToListenersThread.start();
        }
    }

    public synchronized void removeListener(ListenerType listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.dispatchingToListenersThread.halt();
            this.dispatchingToListenersThread = null;
        }
    }

    public int getPort() {
        return this.listeningOnPort;
    }

    public DatagramSocket getSocket() {
        return this.udpSocket;
    }

    protected abstract UDPMessageParser<MessageType> getParser();

    private class ToListenerDispatcher
    extends Thread {
        private final LinkedBlockingDeque<MessageType> queue;
        private boolean stopped;

        public ToListenerDispatcher() {
            super("UDPReceiver ToListenerDispatcher");
            this.queue = new LinkedBlockingDeque(10000);
            this.stopped = false;
        }

        public void dispatch(MessageType message) {
            this.queue.offer(message);
        }

        public void halt() {
            this.stopped = true;
        }

        @Override
        public void run() {
            try {
                UDPMessage message = (UDPMessage)this.queue.poll(10000L, TimeUnit.MILLISECONDS);
                while (!this.stopped) {
                    if (message != null) {
                        for (Map.Entry listenerAndValidMessagesOnly : UDPReceiver.this.listeners.entrySet()) {
                            if (((Boolean)listenerAndValidMessagesOnly.getValue()).booleanValue() && !message.isValid()) continue;
                            try {
                                ((UDPMessageListener)listenerAndValidMessagesOnly.getKey()).received(message);
                            }
                            catch (Exception e) {
                                logger.log(Level.WARNING, "Exception " + e.getMessage() + " while trying to dispaatch UDP message " + message + " to listener " + listenerAndValidMessagesOnly.getKey(), e);
                            }
                        }
                    }
                    message = (UDPMessage)this.queue.poll(10000L, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e) {
                logger.warning("Listener thread got interrupted and will now terminate.");
            }
        }
    }
}

