/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard.tagging;

import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagButtonDialog;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagFooterPanel;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagInputPanel;
import com.sap.sailing.gwt.ui.raceboard.tagging.TaggingComponent;
import com.sap.sailing.gwt.ui.raceboard.tagging.TaggingPanelResources;
import com.sap.sse.gwt.client.dialog.ConfirmationDialog;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;

public class TagModificationPanel
extends FlowPanel {
    private final TaggingPanelResources.TagPanelStyle style = TaggingPanelResources.INSTANCE.style();
    private final TaggingComponent taggingComponent;
    private final StringMessages stringMessages;
    private final Label heading;
    private final Panel buttonsPanel;
    private final TagInputPanel inputPanel;
    private final Button editCustomTagButtons;

    protected TagModificationPanel(TaggingComponent taggingComponent, TagFooterPanel tagFooterPanel, SailingServiceAsync sailingService, StringMessages stringMessages, UserService userService, RaceIdentifier raceIdentifier) {
        this.taggingComponent = taggingComponent;
        this.stringMessages = stringMessages;
        this.setStyleName(this.style.tagModificationPanel());
        this.inputPanel = new TagInputPanel(taggingComponent, sailingService, stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.editCustomTagButtons = new Button(stringMessages.tagEditCustomTagButtons());
        this.editCustomTagButtons.setStyleName(this.style.tagDialogButton());
        this.editCustomTagButtons.addStyleName("gwt-Button");
        this.editCustomTagButtons.addClickHandler(event -> {
            if (taggingComponent.isLoggedInAndRaceLogAvailable()) {
                new TagButtonDialog(taggingComponent, tagFooterPanel, sailingService, stringMessages, userService, raceIdentifier);
            }
        });
        this.inputPanel.getOkButton().setText(stringMessages.tagAddTag());
        this.inputPanel.getOkButton().setStyleName(this.style.tagDialogButton());
        this.inputPanel.getOkButton().addStyleName("gwt-Button");
        this.inputPanel.getCancelButton().setText(stringMessages.cancel());
        this.inputPanel.getCancelButton().setStyleName(this.style.tagDialogButton());
        this.inputPanel.getCancelButton().addStyleName("gwt-Button");
        this.buttonsPanel = new FlowPanel();
        this.buttonsPanel.setStyleName(this.style.buttonsPanel());
        this.buttonsPanel.add((Widget)this.editCustomTagButtons);
        this.buttonsPanel.add((Widget)this.inputPanel.getOkButton());
        this.buttonsPanel.add((Widget)this.inputPanel.getCancelButton());
        this.buttonsPanel.setVisible(true);
        FlowPanel headerPanel = new FlowPanel();
        headerPanel.setStyleName(this.style.tagModificationPanelHeader());
        this.heading = new Label(stringMessages.tagAddTags());
        this.heading.setStyleName(this.style.tagModificationPanelHeaderLabel());
        headerPanel.add((Widget)this.heading);
        Button closeFooterButton = new Button("X");
        closeFooterButton.setStyleName(this.style.tagModificationPanelHeaderButton());
        closeFooterButton.setTitle(stringMessages.close());
        closeFooterButton.addClickHandler(event -> {
            if (taggingComponent.getCurrentState().equals((Object)TaggingComponent.State.CREATE_TAG) && !this.inputPanel.isInputEmpty() || taggingComponent.getCurrentState().equals((Object)TaggingComponent.State.EDIT_TAG) && !this.inputPanel.compareFieldsToTag(taggingComponent.getSelectedTag())) {
                ConfirmationDialog.create((String)stringMessages.tagDiscardChangesHeading(), (String)stringMessages.tagDiscardChanges(), (String)stringMessages.confirm(), (String)stringMessages.cancel(), () -> this.resetState()).center();
            } else {
                this.resetState();
            }
        });
        headerPanel.add((Widget)closeFooterButton);
        this.add((Widget)headerPanel);
        this.add((Widget)this.inputPanel.getStatusLabel());
        this.add((Widget)this.inputPanel);
        this.add((Widget)this.buttonsPanel);
    }

    protected void setCurrentStatus(TaggingComponent.State state) {
        if (state.equals((Object)TaggingComponent.State.EDIT_TAG)) {
            this.heading.setText(this.stringMessages.tagEditTag());
            this.editCustomTagButtons.setVisible(false);
            this.inputPanel.getOkButton().setText(this.stringMessages.save());
            this.inputPanel.getCancelButton().setVisible(true);
            this.inputPanel.setTag(this.taggingComponent.getSelectedTag());
            this.inputPanel.validateAndUpdate();
        } else {
            this.heading.setText(this.stringMessages.tagAddTags());
            this.editCustomTagButtons.setVisible(true);
            this.inputPanel.getOkButton().setText(this.stringMessages.tagAddTag());
            this.inputPanel.getCancelButton().setVisible(false);
        }
        this.inputPanel.setCurrentStatus();
    }

    private void resetState() {
        this.inputPanel.clearAllValues();
        this.taggingComponent.setCurrentState(TaggingComponent.State.VIEW);
    }

    static /* synthetic */ TagInputPanel access$0(TagModificationPanel tagModificationPanel) {
        return tagModificationPanel.inputPanel;
    }

    static /* synthetic */ void access$1(TagModificationPanel tagModificationPanel) {
        tagModificationPanel.resetState();
    }
}

