/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard;

import com.google.gwt.core.client.Scheduler;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.gwt.settings.client.leaderboard.SingleRaceLeaderboardSettings;
import com.sap.sailing.gwt.ui.client.shared.charts.MultiCompetitorRaceChart;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMap;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapSettings;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapZoomSettings;
import com.sap.sailing.gwt.ui.leaderboard.SingleRaceLeaderboardPanel;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardComponentContext;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardModeWithPerRaceCompetitors;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardPanel;
import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.SecurityChildSettingsContext;
import com.sap.sse.security.ui.settings.ComponentContextWithSettingsStorageAndAdditionalSettingsLayers;
import java.util.ArrayList;
import java.util.Collections;

public class StartAnalysisMode
extends RaceBoardModeWithPerRaceCompetitors {
    private static final Duration DURATION_AFTER_START_TO_SET_TIMER_TO_FOR_START_ANALYSIS = Duration.ONE_SECOND.times(10L);
    private static final Duration DURATION_BEFORE_START_TO_INCLUDE_IN_CHART_TIME_RANGE = Duration.ONE_SECOND.times(30L);
    private static final Duration DURATION_AFTER_START_TO_INCLUDE_IN_CHART_TIME_RANGE = Duration.ONE_SECOND.times(30L);
    private MultiCompetitorRaceChart competitorChart;
    private boolean leaderboardSettingsAdjusted;
    private boolean competitorSelectionUpdated;
    private boolean timerAdjusted;
    private boolean mapSettingsAndTimeZoomAdjusted;

    public void applyTo(RaceBoardPanel raceBoardPanel) {
        super.applyTo(raceBoardPanel);
        this.competitorChart = raceBoardPanel.getCompetitorChart();
    }

    protected void updateCompetitorSelection() {
        this.updateCompetitorSelection(3, this.getLeaderboardForSpecificTimePoint());
    }

    private void adjustMapSettings() {
        RaceMap raceMap = this.getRaceBoardPanel().getMap();
        RaceMapSettings defaultSettings = raceMap.getLifecycle().createDefaultSettings();
        RaceMapZoomSettings raceMapZoomSettings = new RaceMapZoomSettings(Collections.singleton(RaceMapZoomSettings.ZoomTypes.BOATS), false);
        boolean isWindUp = true;
        RaceMapSettings additiveSettings = new RaceMapSettings.RaceMapSettingsBuilder(defaultSettings, raceMap.getLifecycle().getRaceDTO(), raceMap.getLifecycle().getPaywallResolver()).withZoomSettings(raceMapZoomSettings).withWindUp(Boolean.valueOf(isWindUp)).build();
        ((RaceBoardComponentContext)raceMap.getComponentContext()).addModesPatching((Component)raceMap, (GenericSerializableSettings)additiveSettings, (ComponentContextWithSettingsStorageAndAdditionalSettingsLayers.OnSettingsReloadedCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void trigger() {
        if (!this.timerAdjusted && this.getRaceTimesInfoForRace() != null && this.getRaceTimesInfoForRace().startOfRace != null) {
            this.timerAdjusted = true;
            this.stopReceivingRaceTimesInfos();
            if (this.getTimer().getPlayMode() == Timer.PlayModes.Live) {
                this.getTimer().setPlayMode(Timer.PlayModes.Replay);
            }
            this.getTimer().pause();
            this.getTimer().setTime(new MillisecondsTimePoint(this.getRaceTimesInfoForRace().startOfRace).plus(DURATION_AFTER_START_TO_SET_TIMER_TO_FOR_START_ANALYSIS).asMillis());
            if (!this.mapSettingsAndTimeZoomAdjusted) {
                this.mapSettingsAndTimeZoomAdjusted = true;
                Scheduler.get().scheduleFixedDelay((Scheduler.RepeatingCommand)new /* Unavailable Anonymous Inner Class!! */, 500);
            }
        }
        if (!this.leaderboardSettingsAdjusted && this.getLeaderboard() != null) {
            this.leaderboardSettingsAdjusted = true;
            this.stopReceivingLeaderboard();
            this.adjustLeaderboardSettings();
        }
        if (this.getLeaderboardForSpecificTimePoint() == null && this.getRaceColumn() != null && this.getLeaderboard() != null && this.timerAdjusted) {
            this.loadLeaderboardForSpecificTimePoint(this.getLeaderboard().getName(), this.getRaceColumn().getName(), this.getTimer().getTime());
        }
        if (!this.competitorSelectionUpdated && this.getLeaderboardForSpecificTimePoint() != null && this.getCompetitorsInRace() != null) {
            this.competitorSelectionUpdated = true;
            this.stopReceivingCompetitorsInRace();
            this.updateCompetitorSelection();
        }
    }

    private void adjustLeaderboardSettings() {
        SingleRaceLeaderboardPanel leaderboardPanel = this.getLeaderboardPanel();
        ArrayList<DetailType> raceDetailsToShow = new ArrayList<DetailType>();
        raceDetailsToShow.add(DetailType.RACE_SPEED_OVER_GROUND_FIVE_SECONDS_BEFORE_START);
        raceDetailsToShow.add(DetailType.RACE_DISTANCE_TO_START_FIVE_SECONDS_BEFORE_RACE_START);
        raceDetailsToShow.add(DetailType.DISTANCE_TO_START_AT_RACE_START);
        raceDetailsToShow.add(DetailType.DISTANCE_TO_STARBOARD_END_OF_STARTLINE_WHEN_PASSING_START_IN_METERS);
        raceDetailsToShow.add(DetailType.SPEED_OVER_GROUND_AT_RACE_START);
        raceDetailsToShow.add(DetailType.SPEED_OVER_GROUND_WHEN_PASSING_START);
        raceDetailsToShow.add(DetailType.TIME_BETWEEN_RACE_START_AND_COMPETITOR_START);
        raceDetailsToShow.add(DetailType.START_TACK);
        raceDetailsToShow.add(DetailType.RACE_GAP_TO_LEADER_IN_SECONDS);
        SecurityChildSettingsContext context = new SecurityChildSettingsContext((SecuredDTO)this.getLeaderboard(), leaderboardPanel.getPaywallResolver());
        SingleRaceLeaderboardSettings additiveSettings = SingleRaceLeaderboardSettings.createDefaultSettingsWithRaceDetailValues(raceDetailsToShow, (SecurityChildSettingsContext)context);
        ((RaceBoardComponentContext)leaderboardPanel.getComponentContext()).addModesPatching((Component)leaderboardPanel, (GenericSerializableSettings)additiveSettings, (ComponentContextWithSettingsStorageAndAdditionalSettingsLayers.OnSettingsReloadedCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean isCompetitorChartEnabled() {
        return this.competitorChart != null;
    }

    static /* synthetic */ boolean access$0(StartAnalysisMode startAnalysisMode) {
        return startAnalysisMode.isCompetitorChartEnabled();
    }

    static /* synthetic */ MultiCompetitorRaceChart access$1(StartAnalysisMode startAnalysisMode) {
        return startAnalysisMode.competitorChart;
    }

    static /* synthetic */ Duration access$2() {
        return DURATION_BEFORE_START_TO_INCLUDE_IN_CHART_TIME_RANGE;
    }

    static /* synthetic */ Duration access$3() {
        return DURATION_AFTER_START_TO_INCLUDE_IN_CHART_TIME_RANGE;
    }

    static /* synthetic */ void access$4(StartAnalysisMode startAnalysisMode) {
        startAnalysisMode.adjustMapSettings();
    }
}

