/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.gwt.ui.client.DetailTypeFormatter;
import com.sap.sailing.gwt.ui.client.NumberFormatterFactory;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.DetailTypeColumn;
import com.sap.sailing.gwt.ui.leaderboard.ExpandableSortableColumn;
import com.sap.sailing.gwt.ui.leaderboard.HasStringAndDoubleValue;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.MinMaxRenderer;
import com.sap.sailing.gwt.ui.leaderboard.OverallTimeTraveledColumn;
import com.sap.sailing.gwt.ui.leaderboard.SortableExpandableColumnHeader;
import com.sap.sailing.gwt.ui.leaderboard.TotalTimeColumn;
import com.sap.sse.common.InvertibleComparator;
import com.sap.sse.gwt.client.celltable.AbstractSortableColumnWithMinMax;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class OverallTimeTraveledColumn
extends ExpandableSortableColumn<String>
implements HasStringAndDoubleValue<LeaderboardRowDTO> {
    private static final DetailType DETAIL_TYPE = DetailType.OVERALL_TOTAL_TIME_SAILED_IN_SECONDS;
    private StringMessages stringMessages;
    private String columnStyle;
    private String headerStyle;
    private MinMaxRenderer<LeaderboardRowDTO> minmaxRenderer;

    public OverallTimeTraveledColumn(LeaderboardPanel<?> leaderboardPanel, StringMessages stringMessages, String headerStyle, String columnStyle, String detailHeaderStyle, String detailColumnStyle) {
        super(leaderboardPanel, true, (Cell)new TextCell(), DETAIL_TYPE.getDefaultSortingOrder(), stringMessages, detailHeaderStyle, detailColumnStyle, Arrays.asList(DetailType.TOTAL_TIME_SAILED_DOWNWIND_IN_SECONDS, DetailType.TOTAL_TIME_SAILED_UPWIND_IN_SECONDS, DetailType.TOTAL_TIME_SAILED_REACHING_IN_SECONDS), leaderboardPanel);
        this.setHorizontalAlignment(ALIGN_CENTER);
        this.stringMessages = stringMessages;
        this.columnStyle = columnStyle;
        this.headerStyle = headerStyle;
        this.minmaxRenderer = new MinMaxRenderer((HasStringAndDoubleValue)this, (Comparator)this.getComparator());
    }

    public Double getDoubleValue(LeaderboardRowDTO row) {
        return row.totalTimeSailedInSeconds;
    }

    protected Map<DetailType, AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>> getDetailColumnMap(LeaderboardPanel<?> leaderboardPanel, StringMessages stringConstants, String detailHeaderStyle, String detailColumnStyle) {
        HashMap result = new HashMap();
        result.put(DetailType.TOTAL_TIME_SAILED_UPWIND_IN_SECONDS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new TotalTimeColumn(DetailType.TOTAL_TIME_SAILED_UPWIND_IN_SECONDS, (DetailTypeColumn.DataExtractor)new TotalTimeSailedUpwindInSeconds(null), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.TOTAL_TIME_SAILED_DOWNWIND_IN_SECONDS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new TotalTimeColumn(DetailType.TOTAL_TIME_SAILED_DOWNWIND_IN_SECONDS, (DetailTypeColumn.DataExtractor)new TotalTimeSailedDownwindInSeconds(null), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.TOTAL_TIME_SAILED_REACHING_IN_SECONDS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new TotalTimeColumn(DetailType.TOTAL_TIME_SAILED_REACHING_IN_SECONDS, (DetailTypeColumn.DataExtractor)new TotalTimeSailedReachingInSeconds(null), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        return result;
    }

    public String getValue(LeaderboardRowDTO object) {
        Double result = this.getDoubleValue(object);
        if (result == null) {
            return "";
        }
        Integer intResult = (int)result.doubleValue();
        return intResult.toString();
    }

    public SortableExpandableColumnHeader getHeader() {
        SortableExpandableColumnHeader result = new SortableExpandableColumnHeader(DetailTypeFormatter.format((DetailType)DETAIL_TYPE), DetailTypeFormatter.getTooltip((DetailType)DETAIL_TYPE), DetailTypeFormatter.getUnit((DetailType)DETAIL_TYPE), null, this.getLeaderboardPanel(), (ExpandableSortableColumn)this, this.stringMessages);
        return result;
    }

    public InvertibleComparator<LeaderboardRowDTO> getComparator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public String getStringValueToRender(LeaderboardRowDTO row) {
        String result;
        Double timeInSeconds = this.getDoubleValue(row);
        if (timeInSeconds == null) {
            result = null;
        } else {
            int hh = (int)(timeInSeconds / 3600.0);
            int mm = (int)((timeInSeconds - (double)(3600 * hh)) / 60.0);
            int ss = (int)(timeInSeconds - (double)(3600 * hh) - (double)(60 * mm));
            NumberFormat numberFormat = NumberFormatterFactory.getDecimalFormat((int)2, (int)0);
            result = numberFormat.format((double)hh) + ":" + numberFormat.format((double)mm) + ":" + numberFormat.format((double)ss);
        }
        return result;
    }

    public void render(Cell.Context context, LeaderboardRowDTO row, SafeHtmlBuilder sb) {
        this.minmaxRenderer.render(context, (Object)row, this.getTitle(row), sb);
    }

    public void updateMinMax() {
        this.minmaxRenderer.updateMinMax(this.getDisplayedLeaderboardRowsProvider().getRowsToDisplay().values());
    }

    protected String getTitle(LeaderboardRowDTO row) {
        return null;
    }

    public String getColumnStyle() {
        return this.columnStyle;
    }

    public String getHeaderStyle() {
        return this.headerStyle;
    }
}

