/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.settings.client.settingtypes.DistanceSetting;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapHelpLinesSettings;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapSettings;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapZoomSettings;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.generic.AbstractGenericSerializableSettings;
import com.sap.sse.common.settings.generic.AbstractGenericSerializableSettingsWithContext;
import com.sap.sse.common.settings.generic.BooleanSetting;
import com.sap.sse.common.settings.generic.DoubleSetting;
import com.sap.sse.common.settings.generic.EnumSetSetting;
import com.sap.sse.common.settings.generic.IntegerSetting;
import com.sap.sse.common.settings.generic.LongSetting;
import com.sap.sse.gwt.shared.GwtHttpRequestUtils;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.SecurityChildSettingsContext;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.settings.SecuredBooleanSetting;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
public class RaceMapSettings
extends AbstractGenericSerializableSettingsWithContext<SecurityChildSettingsContext> {
    private static final long serialVersionUID = 6283369783437892096L;
    private static final String SHOW_MANEUVER_LOSS_VISUALIZATION = "showManeuverLossVisualization";
    private static final String START_COUNT_DOWN_FONT_SIZE_SCALING = "startCountDownFontSizeScaling";
    private static final String SHOW_ESTIMATED_DURATION = "showEstimatedDuration";
    private static final String SHOW_DOUGLAS_PEUCKER_POINTS = "showDouglasPeuckerPoints";
    private static final String MANEUVER_TYPES_TO_SHOW = "maneuverTypesToShow";
    private static final String SHOW_SELECTED_COMPETITORS_INFO = "showSelectedCompetitorsInfo";
    private static final String SHOW_ONLY_SELECTED_COMPETITORS = "showOnlySelectedCompetitors";
    public static final String TAIL_LENGTH_IN_MILLISECONDS = "tailLengthInMilliseconds";
    private static final String HOVERLINE_STROKE_WEIGHT = "hoverlineStrokeWeight";
    private static final String TRANSPARENT_HOVERLINES = "transparentHoverlines";
    private static final String HELP_LINES_SETTINGS = "helpLinesSettings";
    private static final String ZOOM_SETTINGS = "zoomSettings";
    private static final String PARAM_SHOW_SATELLITE_LAYER = "showSatelliteLayer";
    public static final String PARAM_SHOW_MAPCONTROLS = "showMapControls";
    public static final String PARAM_SHOW_COURSE_GEOMETRY = "showCourseGeometry";
    public static final String PARAM_MAP_ORIENTATION_WIND_UP = "windUp";
    private static final String PARAM_VIEW_SHOW_STREAMLETS = "viewShowStreamlets";
    private static final String PARAM_VIEW_SHOW_STREAMLET_COLORS = "viewShowStreamletColors";
    private static final String PARAM_VIEW_SHOW_SIMULATION = "viewShowSimulation";
    private static final String PARAM_BUOY_ZONE_RADIUS_IN_METERS = "buoyZoneRadiusInMeters";
    private static final String PARAM_SHOW_WIND_LADDER = "showWindLadder";
    public static final String PARAM_TAIL_LENGTH_IN_MILLISECONDS = "tailLengthInMilliseconds";
    public static final Distance DEFAULT_BUOY_ZONE_RADIUS = new MeterDistance(15.0);
    private static final long DEFAULT_TAIL_LENGTH_IN_MILLISECONDS = Duration.ONE_SECOND.times(100L).asMillis();
    private BooleanSetting showSatelliteLayerSetting;
    private BooleanSetting showDouglasPeuckerPointsSetting;
    private EnumSetSetting<ManeuverType> maneuverTypesToShowSetting;
    private BooleanSetting showOnlySelectedCompetitorsSetting;
    private RaceMapZoomSettings zoomSettings;
    private RaceMapHelpLinesSettings helpLinesSettings;
    private BooleanSetting transparentHoverlinesSetting;
    private IntegerSetting hoverlineStrokeWeightSetting;
    private LongSetting tailLengthInMillisecondsSetting;
    private DistanceSetting buoyZoneRadiusSetting;
    private BooleanSetting showSelectedCompetitorsInfoSetting;
    private SecuredBooleanSetting showWindStreamletColorsSetting;
    private SecuredBooleanSetting showWindStreamletOverlaySetting;
    private SecuredBooleanSetting showSimulationOverlaySetting;
    private BooleanSetting showMapControlsSetting;
    private BooleanSetting showManeuverLossVisualizationSetting;
    private BooleanSetting windUpSetting;
    private BooleanSetting showEstimatedDurationSetting;
    private BooleanSetting showWindLadderSetting;
    private DoubleSetting startCountDownFontSizeScalingSetting;
    private final PaywallResolver paywallResolver;
    private final SecuredDTO securedDTO;

    protected void addChildSettings(SecurityChildSettingsContext context) {
        this.showSatelliteLayerSetting = new BooleanSetting("showSatelliteLayer", (AbstractGenericSerializableSettings)this, Boolean.valueOf(false));
        this.showMapControlsSetting = new BooleanSetting("showMapControls", (AbstractGenericSerializableSettings)this, Boolean.valueOf(true));
        this.helpLinesSettings = new RaceMapHelpLinesSettings("helpLinesSettings", (AbstractGenericSerializableSettings)this);
        this.windUpSetting = new BooleanSetting("windUp", (AbstractGenericSerializableSettings)this, Boolean.valueOf(false));
        this.buoyZoneRadiusSetting = new DistanceSetting("buoyZoneRadiusInMeters", (AbstractGenericSerializableSettings)this, DEFAULT_BUOY_ZONE_RADIUS);
        this.showWindStreamletOverlaySetting = new SecuredBooleanSetting("viewShowStreamlets", (AbstractGenericSerializableSettingsWithContext)this, Boolean.valueOf(false), (HasPermissions.Action)SecuredDomainType.TrackedRaceActions.VIEWSTREAMLETS, context);
        this.showWindStreamletColorsSetting = new SecuredBooleanSetting("viewShowStreamletColors", (AbstractGenericSerializableSettingsWithContext)this, Boolean.valueOf(false), (HasPermissions.Action)SecuredDomainType.TrackedRaceActions.VIEWSTREAMLETS, context);
        this.showSimulationOverlaySetting = new SecuredBooleanSetting("viewShowSimulation", (AbstractGenericSerializableSettingsWithContext)this, Boolean.valueOf(false), (HasPermissions.Action)SecuredDomainType.TrackedRaceActions.SIMULATOR, context);
        this.showWindLadderSetting = new BooleanSetting("showWindLadder", (AbstractGenericSerializableSettings)this, Boolean.valueOf(false));
        this.zoomSettings = new RaceMapZoomSettings("zoomSettings", (AbstractGenericSerializableSettings)this);
        this.transparentHoverlinesSetting = new BooleanSetting("transparentHoverlines", (AbstractGenericSerializableSettings)this, Boolean.valueOf(false));
        this.hoverlineStrokeWeightSetting = new IntegerSetting("hoverlineStrokeWeight", (AbstractGenericSerializableSettings)this, Integer.valueOf(15));
        this.tailLengthInMillisecondsSetting = new LongSetting("tailLengthInMilliseconds", (AbstractGenericSerializableSettings)this, Long.valueOf(DEFAULT_TAIL_LENGTH_IN_MILLISECONDS));
        this.showOnlySelectedCompetitorsSetting = new BooleanSetting("showOnlySelectedCompetitors", (AbstractGenericSerializableSettings)this, Boolean.valueOf(false));
        this.showSelectedCompetitorsInfoSetting = new BooleanSetting("showSelectedCompetitorsInfo", (AbstractGenericSerializableSettings)this, Boolean.valueOf(true));
        this.maneuverTypesToShowSetting = new EnumSetSetting("maneuverTypesToShow", (AbstractGenericSerializableSettings)this, (Iterable)RaceMapSettings.getDefaultManeuvers(), ManeuverType::valueOf);
        this.showDouglasPeuckerPointsSetting = new BooleanSetting("showDouglasPeuckerPoints", (AbstractGenericSerializableSettings)this, Boolean.valueOf(false));
        this.showEstimatedDurationSetting = new BooleanSetting("showEstimatedDuration", (AbstractGenericSerializableSettings)this, Boolean.valueOf(false));
        this.startCountDownFontSizeScalingSetting = new DoubleSetting("startCountDownFontSizeScaling", (AbstractGenericSerializableSettings)this, Double.valueOf(1.0));
        this.showManeuverLossVisualizationSetting = new BooleanSetting("showManeuverLossVisualization", (AbstractGenericSerializableSettings)this, Boolean.valueOf(false));
    }

    public RaceMapSettings(PaywallResolver paywallResolver, SecuredDTO securedDTO) {
        super((Object)new SecurityChildSettingsContext(securedDTO, paywallResolver));
        this.paywallResolver = paywallResolver;
        this.securedDTO = securedDTO;
    }

    public RaceMapSettings(RaceMapZoomSettings zoomSettings, RaceMapHelpLinesSettings helpLinesSettings, Boolean transparentHoverlines, Integer hoverlineStrokeWeight, Long tailLengthInMilliseconds, Boolean windUp, Distance buoyZoneRadius, Boolean showOnlySelectedCompetitors, Boolean showSelectedCompetitorsInfo, Boolean showWindStreamletColors, Boolean showWindStreamletOverlay, Boolean showSimulationOverlay, Boolean showMapControls, Collection<ManeuverType> maneuverTypesToShow, Boolean showDouglasPeuckerPoints, Boolean showEstimatedDuration, Double startCountDownFontSizeScaling, Boolean showManeuverLossVisualization, Boolean showSatelliteLayer, Boolean showWindLadder, PaywallResolver paywallResolver, SecuredDTO securedDTO) {
        this(paywallResolver, securedDTO);
        this.zoomSettings.init(zoomSettings);
        this.helpLinesSettings.init(helpLinesSettings);
        this.transparentHoverlinesSetting.setValue((Object)transparentHoverlines);
        this.hoverlineStrokeWeightSetting.setValue((Object)hoverlineStrokeWeight);
        this.tailLengthInMillisecondsSetting.setValue((Object)tailLengthInMilliseconds);
        this.windUpSetting.setValue((Object)windUp);
        this.buoyZoneRadiusSetting.setValue((Object)buoyZoneRadius);
        this.showOnlySelectedCompetitorsSetting.setValue((Object)showOnlySelectedCompetitors);
        this.showSelectedCompetitorsInfoSetting.setValue((Object)showSelectedCompetitorsInfo);
        this.showWindStreamletColorsSetting.setValue((Object)showWindStreamletColors);
        this.showWindStreamletOverlaySetting.setValue((Object)showWindStreamletOverlay);
        this.showSimulationOverlaySetting.setValue((Object)showSimulationOverlay);
        this.showMapControlsSetting.setValue((Object)showMapControls);
        this.maneuverTypesToShowSetting.setValues(maneuverTypesToShow);
        this.showDouglasPeuckerPointsSetting.setValue((Object)showDouglasPeuckerPoints);
        this.showEstimatedDurationSetting.setValue((Object)showEstimatedDuration);
        this.startCountDownFontSizeScalingSetting.setValue((Object)startCountDownFontSizeScaling);
        this.showManeuverLossVisualizationSetting.setValue((Object)showManeuverLossVisualization);
        this.showSatelliteLayerSetting.setValue((Object)showSatelliteLayer);
        this.showWindLadderSetting.setValue((Object)showWindLadder);
    }

    public static RaceMapSettings getDefaultWithShowMapControls(boolean showMapControlls) {
        RaceMapSettings raceMapSetting = new RaceMapSettings(null, null);
        raceMapSetting.showMapControlsSetting.setValue((Object)showMapControlls);
        return raceMapSetting;
    }

    private static Set<RaceMapHelpLinesSettings.HelpLineTypes> createHelpLineSettings(boolean showCourseGeometry) {
        HashSet<RaceMapHelpLinesSettings.HelpLineTypes> helpLineTypes = new HashSet<RaceMapHelpLinesSettings.HelpLineTypes>();
        Util.addAll((Iterable)new RaceMapHelpLinesSettings().getVisibleHelpLineTypes(), helpLineTypes);
        if (showCourseGeometry) {
            helpLineTypes.add(RaceMapHelpLinesSettings.HelpLineTypes.COURSEGEOMETRY);
        } else {
            helpLineTypes.remove(RaceMapHelpLinesSettings.HelpLineTypes.COURSEGEOMETRY);
        }
        return helpLineTypes;
    }

    public long getEffectiveTailLengthInMilliseconds() {
        return this.helpLinesSettings.isVisible(RaceMapHelpLinesSettings.HelpLineTypes.BOATTAILS) ? this.getTailLengthInMilliseconds() : 0L;
    }

    public long getTailLengthInMilliseconds() {
        return (Long)this.tailLengthInMillisecondsSetting.getValue();
    }

    public boolean isShowDouglasPeuckerPoints() {
        return (Boolean)this.showDouglasPeuckerPointsSetting.getValue();
    }

    public boolean isShowWindStreamletOverlay() {
        return (Boolean)this.showWindStreamletOverlaySetting.getValue();
    }

    public SecuredBooleanSetting getShowWindStreamletOverlaySetting() {
        return this.showWindStreamletOverlaySetting;
    }

    public boolean isShowWindStreamletColors() {
        return (Boolean)this.showWindStreamletColorsSetting.getValue();
    }

    public SecuredBooleanSetting getShowWindStreamletColorsSetting() {
        return this.showWindStreamletColorsSetting;
    }

    public boolean isShowSimulationOverlay() {
        return (Boolean)this.showSimulationOverlaySetting.getValue();
    }

    public SecuredBooleanSetting getShowSimulationOverlaySetting() {
        return this.showSimulationOverlaySetting;
    }

    public boolean isShowManeuverType(ManeuverType maneuverType) {
        return Util.contains((Iterable)this.maneuverTypesToShowSetting.getValues(), (Object)maneuverType);
    }

    public boolean isShowOnlySelectedCompetitors() {
        return (Boolean)this.showOnlySelectedCompetitorsSetting.getValue();
    }

    public RaceMapZoomSettings getZoomSettings() {
        return this.zoomSettings;
    }

    public RaceMapHelpLinesSettings getHelpLinesSettings() {
        return this.helpLinesSettings;
    }

    public boolean getTransparentHoverlines() {
        return (Boolean)this.transparentHoverlinesSetting.getValue();
    }

    public int getHoverlineStrokeWeight() {
        return (Integer)this.hoverlineStrokeWeightSetting.getValue();
    }

    public boolean isShowSelectedCompetitorsInfo() {
        return (Boolean)this.showSelectedCompetitorsInfoSetting.getValue();
    }

    public Distance getBuoyZoneRadius() {
        return (Distance)this.buoyZoneRadiusSetting.getValue();
    }

    public boolean isBuoyZoneRadiusDefaultValue() {
        return this.buoyZoneRadiusSetting.isDefaultValue();
    }

    public double getStartCountDownFontSizeScaling() {
        return (Double)this.startCountDownFontSizeScalingSetting.getValue();
    }

    public boolean isShowManeuverLossVisualization() {
        return (Boolean)this.showManeuverLossVisualizationSetting.getValue();
    }

    public boolean isWindUp() {
        return (Boolean)this.windUpSetting.getValue();
    }

    public boolean isShowMapControls() {
        return (Boolean)this.showMapControlsSetting.getValue();
    }

    public boolean isShowSatelliteLayer() {
        return (Boolean)this.showSatelliteLayerSetting.getValue();
    }

    public boolean isShowWindLadder() {
        return (Boolean)this.showWindLadderSetting.getValue();
    }

    public Set<ManeuverType> getManeuverTypesToShow() {
        return Util.asSet((Iterable)this.maneuverTypesToShowSetting.getValues());
    }

    public boolean isShowEstimatedDuration() {
        return (Boolean)this.showEstimatedDurationSetting.getValue();
    }

    public static HashSet<ManeuverType> getDefaultManeuvers() {
        HashSet<ManeuverType> types = new HashSet<ManeuverType>();
        types.add(ManeuverType.JIBE);
        types.add(ManeuverType.TACK);
        types.add(ManeuverType.PENALTY_CIRCLE);
        return types;
    }

    public static RaceMapSettings readSettingsFromURL(boolean defaultForShowMapControls, boolean defaultForShowCourseGeometry, boolean defaultForMapOrientationWindUp, boolean defaultForViewShowStreamlets, boolean defaultForViewShowStreamletColors, boolean defaultForViewShowSimulation, Long defaultForTailLengthInMilliseconds, PaywallResolver paywallResolver, SecuredDTO securedDTO) {
        boolean showSatelliteLayer = GwtHttpRequestUtils.getBooleanParameter((String)"showSatelliteLayer", (boolean)false);
        boolean showMapControls = GwtHttpRequestUtils.getBooleanParameter((String)"showMapControls", (boolean)defaultForShowMapControls);
        boolean showCourseGeometry = GwtHttpRequestUtils.getBooleanParameter((String)"showCourseGeometry", (boolean)defaultForShowCourseGeometry);
        RaceMapHelpLinesSettings raceMapHelpLinesSettings = new RaceMapHelpLinesSettings((Iterable)RaceMapSettings.createHelpLineSettings((boolean)showCourseGeometry));
        boolean windUp = GwtHttpRequestUtils.getBooleanParameter((String)"windUp", (boolean)defaultForMapOrientationWindUp);
        boolean showWindStreamletOverlay = GwtHttpRequestUtils.getBooleanParameter((String)"viewShowStreamlets", (boolean)defaultForViewShowStreamlets);
        boolean showWindStreamletColors = GwtHttpRequestUtils.getBooleanParameter((String)"viewShowStreamletColors", (boolean)defaultForViewShowStreamletColors);
        boolean showSimulationOverlay = GwtHttpRequestUtils.getBooleanParameter((String)"viewShowSimulation", (boolean)defaultForViewShowSimulation);
        Long tailLengthInMilliseconds = GwtHttpRequestUtils.getLongParameter((String)"tailLengthInMilliseconds", (Long)defaultForTailLengthInMilliseconds);
        double buoyZoneRadiusInMeters = GwtHttpRequestUtils.getDoubleParameter((String)"buoyZoneRadiusInMeters", (double)DEFAULT_BUOY_ZONE_RADIUS.getMeters());
        MeterDistance meterDistance = new MeterDistance(buoyZoneRadiusInMeters);
        return new RaceMapSettingsBuilder(securedDTO, paywallResolver).withShowSatelliteLayer(Boolean.valueOf(showSatelliteLayer)).withShowMapControls(Boolean.valueOf(showMapControls)).withHelpLinesSettings(raceMapHelpLinesSettings).withWindUp(Boolean.valueOf(windUp)).withBuoyZoneRadius((Distance)meterDistance).withShowWindStreamletOverlay(Boolean.valueOf(showWindStreamletOverlay)).withShowWindStreamletColors(Boolean.valueOf(showWindStreamletColors)).withShowSimulationOverlay(Boolean.valueOf(showSimulationOverlay)).withTailLengthInMilliseconds(tailLengthInMilliseconds).build();
    }

    protected PaywallResolver getPaywallResolver() {
        return this.paywallResolver;
    }

    protected SecuredDTO getSecuredDTO() {
        return this.securedDTO;
    }
}

