/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.raceboard.AbstractQuickFlagDataProvider;
import com.sap.sailing.gwt.ui.shared.QuickRankDTO;
import com.sap.sse.common.Util;
import java.util.Collections;
import java.util.Map;

public class DefaultQuickFlagDataProvider
extends AbstractQuickFlagDataProvider {
    private Map<String, QuickRankDTO> currentQuickRanksFromServerByCompetitorIdAsString = Collections.emptyMap();
    private Map<String, Double> currentQuickSpeedsInKnotsFromServerByCompetitorIdAsString = Collections.emptyMap();

    public void quickRanksReceivedFromServer(Map<String, QuickRankDTO> receivedQuickRanksFromServer) {
        Map oldQuickRanksFromServer = this.currentQuickRanksFromServerByCompetitorIdAsString;
        this.currentQuickRanksFromServerByCompetitorIdAsString = Util.nullToEmptyMap(receivedQuickRanksFromServer);
        for (Map.Entry e : this.currentQuickRanksFromServerByCompetitorIdAsString.entrySet()) {
            QuickRankDTO oldQuickRank = (QuickRankDTO)oldQuickRanksFromServer.get(e.getKey());
            if (!Util.equalsWithNull((Object)oldQuickRank, e.getValue())) continue;
            this.notifyListenersRankChanged((String)e.getKey(), oldQuickRank, (QuickRankDTO)e.getValue());
        }
    }

    public Map<String, QuickRankDTO> getQuickRanks() {
        return this.currentQuickRanksFromServerByCompetitorIdAsString;
    }

    public void quickSpeedsInKnotsReceivedFromServer(Map<String, Double> quickSpeedsFromServerInKnotsByCompetitorIdAsString, Map<String, CompetitorDTO> competitorsByIdAsString) {
        Map oldQuickSpeedsFromServerInKnots = this.currentQuickSpeedsInKnotsFromServerByCompetitorIdAsString;
        this.currentQuickSpeedsInKnotsFromServerByCompetitorIdAsString = Util.nullToEmptyMap(quickSpeedsFromServerInKnotsByCompetitorIdAsString);
        for (Map.Entry e : this.currentQuickSpeedsInKnotsFromServerByCompetitorIdAsString.entrySet()) {
            Double oldQuickSpeedInKnots = (Double)oldQuickSpeedsFromServerInKnots.get(e.getKey());
            if (!Util.equalsWithNull((Object)oldQuickSpeedInKnots, e.getValue())) continue;
            this.notifyListenersSpeedInKnotsChanged(competitorsByIdAsString.get(e.getKey()), (Double)e.getValue());
        }
    }

    public Double getQuickSpeedsInKnots(CompetitorDTO competitor) {
        return (Double)this.currentQuickSpeedsInKnotsFromServerByCompetitorIdAsString.get(competitor.getIdAsString());
    }
}

