/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.filter;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.filter.AbstractCompetitorsFilterSetDialog;
import com.sap.sailing.gwt.ui.client.shared.filter.CompetitorFilterWithUIFactory;
import com.sap.sailing.gwt.ui.client.shared.filter.FilterUIFactory;
import com.sap.sailing.gwt.ui.client.shared.filter.FilterWithUI;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.common.filter.FilterSet;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCompetitorsFilterSetDialog
extends DataEntryDialog<FilterSet<CompetitorDTO, FilterWithUI<CompetitorDTO>>> {
    private final FilterSet<CompetitorDTO, FilterWithUI<CompetitorDTO>> competitorsFilterSet;
    private final StringMessages stringMessages;
    private final List<String> availableCompetitorFilterNames;
    private ListBox filterListBox;
    private final Button addFilterButton;
    protected TextBox filterSetNameTextBox;
    private Grid competitorsFiltersGrid;
    private Label competitorsFiltersGridHeadline;
    private Label competitorsFiltersGridFooter;
    private VerticalPanel mainPanel;
    private final List<Widget> filterEditWidgets;
    private final List<FilterUIFactory<CompetitorDTO>> filterUIFactories;
    private final List<Label> filterNameLabels;
    private final List<String> filterNames;
    private final List<Button> filterDeleteButtons;

    public AbstractCompetitorsFilterSetDialog(FilterSet<CompetitorDTO, FilterWithUI<CompetitorDTO>> competitorsFilterSet, List<String> availableCompetitorFilterNames, List<String> existingFilterSetNames, String dialogTitle, StringMessages stringMessages, DataEntryDialog.DialogCallback<FilterSet<CompetitorDTO, FilterWithUI<CompetitorDTO>>> callback) {
        super(dialogTitle, null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new CompetitorsFilterSetValidator(existingFilterSetNames, stringMessages), callback);
        this.competitorsFilterSet = competitorsFilterSet;
        this.availableCompetitorFilterNames = availableCompetitorFilterNames;
        this.stringMessages = stringMessages;
        this.competitorsFiltersGrid = new Grid(0, 0);
        this.competitorsFiltersGridHeadline = new Label();
        this.competitorsFiltersGridFooter = new Label();
        this.filterEditWidgets = new ArrayList();
        this.filterNameLabels = new ArrayList();
        this.filterNames = new ArrayList();
        this.filterUIFactories = new ArrayList();
        this.filterDeleteButtons = new ArrayList();
        this.addFilterButton = new Button(stringMessages.add());
        this.addFilterButton.addStyleName("inlineButton");
        this.addFilterButton.addStyleName("btn-secondary");
        this.filterListBox = this.createListBox(false);
    }

    protected Widget getAdditionalWidget() {
        this.mainPanel = new VerticalPanel();
        Grid hGrid = new Grid(1, 2);
        this.mainPanel.add((Widget)hGrid);
        hGrid.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.filterName()) + ":"));
        Grid filterSetNameTextBoxWrapperGrid = new Grid(1, 1);
        filterSetNameTextBoxWrapperGrid.setWidget(0, 0, (Widget)this.filterSetNameTextBox);
        filterSetNameTextBoxWrapperGrid.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        hGrid.setWidget(0, 1, (Widget)filterSetNameTextBoxWrapperGrid);
        hGrid.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        hGrid.getCellFormatter().setVerticalAlignment(0, 1, HasVerticalAlignment.ALIGN_MIDDLE);
        this.filterListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.filterListBox.addItem(String.valueOf(this.stringMessages.selectAFilterCriteria()) + "...");
        for (String filterName : this.availableCompetitorFilterNames) {
            FilterWithUI filter = CompetitorFilterWithUIFactory.createFilter((String)filterName);
            this.filterListBox.addItem(filter.getLocalizedName(this.stringMessages));
        }
        this.updateSelectedFilterInfo();
        this.addFilterButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Grid competitorsFiltersGridHeadlineGrid = new Grid(1, 1);
        competitorsFiltersGridHeadlineGrid.setWidget(0, 0, (Widget)this.competitorsFiltersGridHeadline);
        competitorsFiltersGridHeadlineGrid.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        this.mainPanel.add((Widget)competitorsFiltersGridHeadlineGrid);
        this.mainPanel.add((Widget)this.competitorsFiltersGrid);
        this.mainPanel.add((Widget)this.competitorsFiltersGridFooter);
        for (FilterWithUI existingFilter : this.competitorsFilterSet.getFilters()) {
            FilterWithUI filter = existingFilter.copy();
            FilterUIFactory filterUIFactory = filter.createUIFactory();
            this.filterUIFactories.add(filterUIFactory);
            this.createFilterNameAndLabel(filter);
            this.createFilterEditWidget(filterUIFactory);
            this.createFilterDeleteButton(filter);
        }
        this.updateCompetitorsFiltersGrid(this.mainPanel);
        Grid addFilterPanel = new Grid(1, 3);
        this.mainPanel.add((Widget)addFilterPanel);
        addFilterPanel.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.filterCriteria()) + ":"));
        Grid filterListBoxWrapperGrid = new Grid(1, 1);
        filterListBoxWrapperGrid.setWidget(0, 0, (Widget)this.filterListBox);
        filterListBoxWrapperGrid.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        addFilterPanel.setWidget(0, 1, (Widget)filterListBoxWrapperGrid);
        addFilterPanel.setWidget(0, 2, (Widget)this.addFilterButton);
        addFilterPanel.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        addFilterPanel.getCellFormatter().setVerticalAlignment(0, 1, HasVerticalAlignment.ALIGN_MIDDLE);
        addFilterPanel.getCellFormatter().setVerticalAlignment(0, 2, HasVerticalAlignment.ALIGN_MIDDLE);
        return this.mainPanel;
    }

    private Label createFilterNameAndLabel(FilterWithUI<CompetitorDTO> filter) {
        Label filterNameLabel = new Label(String.valueOf(filter.getLocalizedName(this.stringMessages)) + ":");
        this.filterNameLabels.add(filterNameLabel);
        this.filterNames.add(filter.getName());
        return filterNameLabel;
    }

    private Widget createFilterEditWidget(FilterUIFactory<CompetitorDTO> filterUIFactory) {
        Widget filterEditWidget = filterUIFactory.createFilterUIWidget((DataEntryDialog)this);
        this.filterEditWidgets.add(filterEditWidget);
        return filterEditWidget;
    }

    private Button createFilterDeleteButton(FilterWithUI<CompetitorDTO> filter) {
        Button filterDeleteBtn = new Button(this.stringMessages.delete());
        filterDeleteBtn.addStyleName("inlineButton");
        filterDeleteBtn.addStyleName("btn-secondary");
        this.filterDeleteButtons.add(filterDeleteBtn);
        filterDeleteBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return filterDeleteBtn;
    }

    private void updateSelectedFilterInfo() {
        FilterWithUI selectedFilter = this.getFilterFromSelectedFilterName();
        if (selectedFilter != null) {
            this.addFilterButton.setEnabled(true);
        } else {
            this.addFilterButton.setEnabled(false);
        }
    }

    protected FilterSet<CompetitorDTO, FilterWithUI<CompetitorDTO>> getResult() {
        FilterSet result = new FilterSet(this.filterSetNameTextBox.getText());
        for (FilterUIFactory filterUIFactory : this.filterUIFactories) {
            result.addFilter((Filter)filterUIFactory.createFilterFromUI());
        }
        return result;
    }

    private FilterWithUI<CompetitorDTO> getFilterFromSelectedFilterName() {
        FilterWithUI result = null;
        int selectedIndex = this.filterListBox.getSelectedIndex();
        if (selectedIndex > 0) {
            String selectedItemValue = this.filterListBox.getValue(selectedIndex);
            for (String filterName : this.availableCompetitorFilterNames) {
                FilterWithUI filter = CompetitorFilterWithUIFactory.createFilter((String)filterName);
                if (!selectedItemValue.equals(filter.getLocalizedName(this.stringMessages))) continue;
                result = filter;
                break;
            }
        }
        return result;
    }

    private void updateCompetitorsFiltersGrid(VerticalPanel parentPanel) {
        boolean showGridFooter;
        int widgetIndex = parentPanel.getWidgetIndex((Widget)this.competitorsFiltersGrid);
        parentPanel.remove((Widget)this.competitorsFiltersGrid);
        int filterCount = this.filterNameLabels.size();
        boolean showGridHeadline = filterCount >= 1;
        boolean bl = showGridFooter = filterCount >= 1;
        if (filterCount > 0) {
            this.competitorsFiltersGrid = new Grid(filterCount, 3);
            this.competitorsFiltersGrid.setCellSpacing(4);
            this.competitorsFiltersGridHeadline.setVisible(showGridHeadline);
            this.competitorsFiltersGridFooter.setVisible(showGridFooter);
            if (showGridHeadline) {
                this.competitorsFiltersGridHeadline.setText(this.stringMessages.competitorFilterExplanation());
            }
            if (showGridFooter) {
                this.competitorsFiltersGridFooter.setText("");
            }
            int i = 0;
            while (i < filterCount) {
                this.competitorsFiltersGrid.setWidget(i, 0, (Widget)this.filterNameLabels.get(i));
                this.competitorsFiltersGrid.setWidget(i, 1, (Widget)this.filterEditWidgets.get(i));
                this.competitorsFiltersGrid.setWidget(i, 2, (Widget)this.filterDeleteButtons.get(i));
                this.competitorsFiltersGrid.getCellFormatter().setVerticalAlignment(i, 0, HasVerticalAlignment.ALIGN_MIDDLE);
                this.competitorsFiltersGrid.getCellFormatter().setVerticalAlignment(i, 1, HasVerticalAlignment.ALIGN_MIDDLE);
                this.competitorsFiltersGrid.getCellFormatter().setVerticalAlignment(i, 2, HasVerticalAlignment.ALIGN_MIDDLE);
                ++i;
            }
        } else {
            this.competitorsFiltersGrid = new Grid(0, 0);
        }
        parentPanel.insert((Widget)this.competitorsFiltersGrid, widgetIndex);
    }

    protected Focusable getInitialFocusWidget() {
        return this.filterSetNameTextBox;
    }

    static /* synthetic */ void access$1(AbstractCompetitorsFilterSetDialog abstractCompetitorsFilterSetDialog) {
        abstractCompetitorsFilterSetDialog.updateSelectedFilterInfo();
    }

    static /* synthetic */ FilterWithUI access$2(AbstractCompetitorsFilterSetDialog abstractCompetitorsFilterSetDialog) {
        return abstractCompetitorsFilterSetDialog.getFilterFromSelectedFilterName();
    }

    static /* synthetic */ List access$3(AbstractCompetitorsFilterSetDialog abstractCompetitorsFilterSetDialog) {
        return abstractCompetitorsFilterSetDialog.filterUIFactories;
    }

    static /* synthetic */ Label access$4(AbstractCompetitorsFilterSetDialog abstractCompetitorsFilterSetDialog, FilterWithUI filterWithUI) {
        return abstractCompetitorsFilterSetDialog.createFilterNameAndLabel(filterWithUI);
    }

    static /* synthetic */ Widget access$5(AbstractCompetitorsFilterSetDialog abstractCompetitorsFilterSetDialog, FilterUIFactory filterUIFactory) {
        return abstractCompetitorsFilterSetDialog.createFilterEditWidget(filterUIFactory);
    }

    static /* synthetic */ Button access$6(AbstractCompetitorsFilterSetDialog abstractCompetitorsFilterSetDialog, FilterWithUI filterWithUI) {
        return abstractCompetitorsFilterSetDialog.createFilterDeleteButton(filterWithUI);
    }

    static /* synthetic */ VerticalPanel access$7(AbstractCompetitorsFilterSetDialog abstractCompetitorsFilterSetDialog) {
        return abstractCompetitorsFilterSetDialog.mainPanel;
    }

    static /* synthetic */ void access$8(AbstractCompetitorsFilterSetDialog abstractCompetitorsFilterSetDialog, VerticalPanel verticalPanel) {
        abstractCompetitorsFilterSetDialog.updateCompetitorsFiltersGrid(verticalPanel);
    }

    static /* synthetic */ void access$9(AbstractCompetitorsFilterSetDialog abstractCompetitorsFilterSetDialog) {
        abstractCompetitorsFilterSetDialog.validateAndUpdate();
    }

    static /* synthetic */ List access$10(AbstractCompetitorsFilterSetDialog abstractCompetitorsFilterSetDialog) {
        return abstractCompetitorsFilterSetDialog.filterDeleteButtons;
    }

    static /* synthetic */ List access$11(AbstractCompetitorsFilterSetDialog abstractCompetitorsFilterSetDialog) {
        return abstractCompetitorsFilterSetDialog.filterNames;
    }

    static /* synthetic */ List access$12(AbstractCompetitorsFilterSetDialog abstractCompetitorsFilterSetDialog) {
        return abstractCompetitorsFilterSetDialog.filterNameLabels;
    }

    static /* synthetic */ List access$13(AbstractCompetitorsFilterSetDialog abstractCompetitorsFilterSetDialog) {
        return abstractCompetitorsFilterSetDialog.filterEditWidgets;
    }
}

