/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.adminconsole.AbstractLeaderboardDialog;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardDescriptor;
import com.sap.sailing.gwt.ui.adminconsole.RegattaLeaderboardDialog;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class RegattaLeaderboardDialog<LD extends LeaderboardDescriptor>
extends AbstractLeaderboardDialog<LD> {
    protected ListBox regattaListBox;
    protected Collection<RegattaDTO> existingRegattas;
    protected Label regattaDefinesDiscardsLabel;

    public RegattaLeaderboardDialog(String title, LD leaderboardDescriptor, Collection<RegattaDTO> existingRegattas, StringMessages stringMessages, ErrorReporter errorReporter, LeaderboardParameterValidator<LD> validator, DataEntryDialog.DialogCallback<LD> callback) {
        super(title, leaderboardDescriptor, stringMessages, validator, callback);
        this.existingRegattas = existingRegattas;
        this.regattaDefinesDiscardsLabel = new Label(stringMessages.regattaDefinesResultDiscardingRules());
    }

    protected void adjustVisibilityOfResultDiscardingRuleComponent() {
        if (this.getSelectedRegatta().definesSeriesDiscardThresholds()) {
            if (this.discardThresholdBoxes != null) {
                this.discardThresholdBoxes.getWidget().setVisible(false);
            }
            this.regattaDefinesDiscardsLabel.setVisible(true);
        } else {
            if (this.discardThresholdBoxes != null) {
                this.discardThresholdBoxes.getWidget().setVisible(true);
            }
            this.regattaDefinesDiscardsLabel.setVisible(false);
        }
    }

    protected ListBox createSortedRegattaListBox(Collection<RegattaDTO> regattas, String preSelectedRegattaName) {
        ListBox result = this.createListBox(false);
        ArrayList<String> sortedRegattaNames = new ArrayList<String>();
        for (RegattaDTO regatta : this.existingRegattas) {
            sortedRegattaNames.add(regatta.getName());
        }
        Collections.sort(sortedRegattaNames);
        result.addItem(this.stringMessages.pleaseSelectARegatta());
        int i = 1;
        for (String regattaName : sortedRegattaNames) {
            result.addItem(regattaName);
            if (preSelectedRegattaName != null && regattaName.equals(preSelectedRegattaName)) {
                result.setSelectedIndex(i);
            }
            ++i;
        }
        return result;
    }

    protected LD getResult() {
        LeaderboardDescriptor leaderboard = super.getResult();
        leaderboard.setRegattaName(this.getSelectedRegatta() != null ? this.getSelectedRegatta().getName() : null);
        return (LD)leaderboard;
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel mainPanel = new VerticalPanel();
        Grid formGrid = new Grid(3, 3);
        formGrid.setCellSpacing(3);
        formGrid.setWidget(0, 0, (Widget)this.createLabel(this.stringMessages.regatta()));
        formGrid.setWidget(0, 1, (Widget)this.regattaListBox);
        formGrid.setWidget(1, 0, (Widget)this.createLabel(this.stringMessages.name()));
        formGrid.setWidget(1, 1, (Widget)this.nameTextBox);
        formGrid.setWidget(2, 0, (Widget)this.createLabel(this.stringMessages.displayName()));
        formGrid.setWidget(2, 1, (Widget)this.displayNameTextBox);
        mainPanel.add((Widget)formGrid);
        mainPanel.add((Widget)this.regattaDefinesDiscardsLabel);
        if (this.discardThresholdBoxes != null) {
            mainPanel.add(this.discardThresholdBoxes.getWidget());
            this.regattaDefinesDiscardsLabel.setVisible(false);
        }
        return mainPanel;
    }

    public RegattaDTO getSelectedRegatta() {
        RegattaDTO result = null;
        int selIndex = this.regattaListBox.getSelectedIndex();
        if (selIndex > 0) {
            String itemValue = this.regattaListBox.getValue(selIndex);
            for (RegattaDTO regattaDTO : this.existingRegattas) {
                if (!regattaDTO.getName().equals(itemValue)) continue;
                result = regattaDTO;
                break;
            }
        }
        return result;
    }
}

