/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.gwt.ui.adminconsole.AbstractLeaderboardDialog;
import com.sap.sailing.gwt.ui.adminconsole.DiscardThresholdBoxes;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardGroupDialog;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupDTO;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.Arrays;
import java.util.Collection;

public class LeaderboardGroupDialog
extends DataEntryDialog<LeaderboardGroupDescriptor> {
    protected StringMessages stringMessages;
    protected TextBox nameEntryField;
    protected TextArea descriptionEntryField;
    protected TextBox displayNameEntryField;
    protected CheckBox displayLeaderboardsInReverseOrderCheckBox;
    protected CheckBox useOverallLeaderboardCheckBox;
    private Panel overallLeaderboardConfigPanel;
    private DiscardThresholdBoxes overallLeaderboardDiscardThresholdBoxes;
    private ListBox overallLeaderboardScoringSchemeListBox;

    protected ListBox getOverallLeaderboardScoringSchemeListBox() {
        return this.overallLeaderboardScoringSchemeListBox;
    }

    public LeaderboardGroupDialog(LeaderboardGroupDTO group, StringMessages stringMessages, DataEntryDialog.DialogCallback<LeaderboardGroupDescriptor> callback, Collection<LeaderboardGroupDTO> existingLeaderboardGroups) {
        super(stringMessages.leaderboardGroup(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new LeaderboardGroupParameterValidator(stringMessages, existingLeaderboardGroups), callback);
        this.stringMessages = stringMessages;
        this.displayLeaderboardsInReverseOrderCheckBox = this.createCheckbox(stringMessages.displayGroupsInReverseOrder());
        this.displayLeaderboardsInReverseOrderCheckBox.ensureDebugId("DisplayGroupsInReverseOrderCheckBox");
        this.useOverallLeaderboardCheckBox = this.createCheckbox(stringMessages.useOverallLeaderboard());
        this.useOverallLeaderboardCheckBox.ensureDebugId("UseOverallLeaderboardCheckBox");
        Grid formGrid = new Grid(3, 2);
        formGrid.setCellSpacing(3);
        formGrid.setWidget(0, 0, (Widget)new Label(String.valueOf(stringMessages.scoringSystem()) + ":"));
        this.overallLeaderboardScoringSchemeListBox = AbstractLeaderboardDialog.createScoringSchemeListBox((DataEntryDialog)this, (StringMessages)stringMessages);
        if (group.getOverallLeaderboardScoringSchemeType() != null) {
            this.overallLeaderboardScoringSchemeListBox.setSelectedIndex(Arrays.asList(ScoringSchemeType.values()).indexOf(group.getOverallLeaderboardScoringSchemeType()));
        }
        formGrid.setWidget(0, 1, (Widget)this.overallLeaderboardScoringSchemeListBox);
        this.overallLeaderboardDiscardThresholdBoxes = group.hasOverallLeaderboard() ? new DiscardThresholdBoxes((DataEntryDialog)this, group.getOverallLeaderboardDiscardThresholds(), stringMessages) : new DiscardThresholdBoxes((DataEntryDialog)this, stringMessages);
        formGrid.setWidget(1, 1, this.overallLeaderboardDiscardThresholdBoxes.getWidget());
        this.overallLeaderboardConfigPanel = formGrid;
    }

    protected LeaderboardGroupDescriptor getResult() {
        return new LeaderboardGroupDescriptor(this.nameEntryField.getText().trim(), this.descriptionEntryField.getText(), this.displayNameEntryField.getText().trim().isEmpty() ? null : this.displayNameEntryField.getText(), this.displayLeaderboardsInReverseOrderCheckBox.getValue().booleanValue(), this.useOverallLeaderboardCheckBox.getValue().booleanValue(), this.useOverallLeaderboardCheckBox.getValue() != false ? this.overallLeaderboardDiscardThresholdBoxes.getDiscardThresholds() : null, this.useOverallLeaderboardCheckBox.getValue() != false ? AbstractLeaderboardDialog.getSelectedScoringSchemeType((ListBox)this.overallLeaderboardScoringSchemeListBox, (StringMessages)this.stringMessages) : null);
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel panel = new VerticalPanel();
        Widget additionalWidget = super.getAdditionalWidget();
        if (additionalWidget != null) {
            panel.add(additionalWidget);
        }
        panel.add((Widget)new Label(this.stringMessages.name()));
        panel.add((Widget)this.nameEntryField);
        panel.add((Widget)new Label(this.stringMessages.description()));
        this.descriptionEntryField.setCharacterWidth(30);
        this.descriptionEntryField.setVisibleLines(6);
        this.descriptionEntryField.getElement().getStyle().setProperty("resize", "none");
        panel.add((Widget)this.descriptionEntryField);
        panel.add((Widget)new Label(this.stringMessages.displayName()));
        this.displayNameEntryField.getElement().getStyle().setProperty("resize", "none");
        panel.add((Widget)this.displayNameEntryField);
        panel.add((Widget)this.displayLeaderboardsInReverseOrderCheckBox);
        panel.add((Widget)this.useOverallLeaderboardCheckBox);
        this.useOverallLeaderboardCheckBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.updateOverallLeaderboardDetailsVisibility(this.useOverallLeaderboardCheckBox.getValue().booleanValue(), (Panel)panel);
        return panel;
    }

    private void updateOverallLeaderboardDetailsVisibility(boolean overallLeaderboardDetailsVisible, Panel panel) {
        if (overallLeaderboardDetailsVisible) {
            this.useOverallLeaderboard(panel);
        } else {
            this.dontUseOverallLeaderboard(panel);
        }
    }

    protected void useOverallLeaderboard(Panel panel) {
        panel.add((Widget)this.overallLeaderboardConfigPanel);
    }

    protected void dontUseOverallLeaderboard(Panel panel) {
        panel.remove((Widget)this.overallLeaderboardConfigPanel);
    }

    protected Focusable getInitialFocusWidget() {
        return this.nameEntryField;
    }

    static /* synthetic */ void access$1(LeaderboardGroupDialog leaderboardGroupDialog, boolean bl, Panel panel) {
        leaderboardGroupDialog.updateOverallLeaderboardDetailsVisibility(bl, panel);
    }
}

