/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.gwt.ui.adminconsole.AbstractCompetitorWithBoatDialog;
import com.sap.sailing.gwt.ui.adminconsole.BoatTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorEditDialog;
import com.sap.sailing.gwt.ui.client.Refresher;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Color;
import com.sap.sse.common.Distance;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;
import java.util.Set;

public class CompetitorWithBoatCreateDialog
extends AbstractCompetitorWithBoatDialog {
    private final RadioButton useExistingBoatRadioButton;
    private final RadioButton useNewBoatRadioButton;
    private final VerticalPanel newBoatPanel;
    private final VerticalPanel existingBoatPanel;
    private final BoatTableWrapper<RefreshableSingleSelectionModel<BoatDTO>> existingBoatsTable;

    public CompetitorWithBoatCreateDialog(SailingServiceWriteAsync sailingServiceWrite, UserService userService, Refresher<BoatDTO> boatsRefresher, Refresher<CompetitorDTO> competitorsRefresher, StringMessages stringMessages, ErrorReporter errorReporter, CompetitorWithBoatDTO competitorToEdit, DataEntryDialog.DialogCallback<CompetitorWithBoatDTO> callback, String boatClass) {
        super("Add competitor with boat", stringMessages, competitorToEdit, callback, boatClass);
        this.ensureDebugId("CompetitorWithBoatCreateDialog");
        this.useNewBoatRadioButton = this.createRadioButton("BoatCreationSelection", "Create new boat");
        this.useExistingBoatRadioButton = this.createRadioButton("BoatCreationSelection", "Use existing boat");
        this.useNewBoatRadioButton.setValue(Boolean.valueOf(true));
        this.useNewBoatRadioButton.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.useExistingBoatRadioButton.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.newBoatPanel = new VerticalPanel();
        this.existingBoatPanel = new VerticalPanel();
        this.existingBoatsTable = new BoatTableWrapper(sailingServiceWrite, userService, boatsRefresher, competitorsRefresher, stringMessages, errorReporter, false, true, 10, false);
        this.existingBoatsTable.refreshBoatList(true, null);
        ((RefreshableSingleSelectionModel)this.existingBoatsTable.getSelectionModel()).addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateBoatPanels() {
        boolean isUseExistingBoatSelected = this.useExistingBoatRadioButton.getValue();
        this.newBoatPanel.setVisible(!isUseExistingBoatSelected);
        this.existingBoatPanel.setVisible(isUseExistingBoatSelected);
    }

    protected BoatDTO getBoat() {
        BoatDTO result = null;
        boolean isUseExistingBoatSelected = this.useExistingBoatRadioButton.getValue();
        if (isUseExistingBoatSelected) {
            Set selectedSet = ((RefreshableSingleSelectionModel)this.existingBoatsTable.getSelectionModel()).getSelectedSet();
            if (!selectedSet.isEmpty()) {
                result = (BoatDTO)selectedSet.iterator().next();
            }
        } else {
            BoatClassDTO boatClass = new BoatClassDTO(this.boatClassNameTextBox.getValue(), (Distance)Distance.NULL, (Distance)Distance.NULL);
            CompetitorEditDialog.InvalidColor boatColor = this.boatDisplayColorTextBox.isValid() ? this.boatDisplayColorTextBox.getColor() : new CompetitorEditDialog.InvalidColor((Exception)new IllegalArgumentException(this.boatDisplayColorTextBox.getValue()), this.getStringMessages());
            result = new BoatDTO(((CompetitorWithBoatDTO)this.getCompetitorToEdit()).getBoat().getIdAsString(), this.boatNameTextBox.getName(), boatClass, this.sailIdTextBox.getText(), (Color)boatColor);
        }
        return result;
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel result = new VerticalPanel();
        result.add(super.getAdditionalWidget());
        result.add((Widget)this.createHeadlineLabel(this.getStringMessages().boat()));
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.add((Widget)this.useNewBoatRadioButton);
        hPanel.add((Widget)this.useExistingBoatRadioButton);
        result.add((Widget)hPanel);
        result.add((Widget)this.newBoatPanel);
        result.add((Widget)this.existingBoatPanel);
        Grid grid = new Grid(4, 2);
        grid.setWidget(0, 0, (Widget)new Label(this.getStringMessages().name()));
        grid.setWidget(0, 1, (Widget)this.boatNameTextBox);
        grid.setWidget(1, 0, (Widget)new Label(this.getStringMessages().sailNumber()));
        grid.setWidget(1, 1, (Widget)this.sailIdTextBox);
        grid.setWidget(2, 0, (Widget)new Label(this.getStringMessages().color()));
        grid.setWidget(2, 1, (Widget)this.boatDisplayColorTextBox);
        grid.setWidget(3, 0, (Widget)new Label(this.getStringMessages().boatClass()));
        grid.setWidget(3, 1, (Widget)this.boatClassNameTextBox);
        result.add((Widget)grid);
        this.newBoatPanel.add((Widget)grid);
        this.existingBoatPanel.add((IsWidget)this.existingBoatsTable);
        this.updateBoatPanels();
        return result;
    }

    static /* synthetic */ void access$0(CompetitorWithBoatCreateDialog competitorWithBoatCreateDialog) {
        competitorWithBoatCreateDialog.updateBoatPanels();
    }

    static /* synthetic */ void access$1(CompetitorWithBoatCreateDialog competitorWithBoatCreateDialog) {
        competitorWithBoatCreateDialog.validateAndUpdate();
    }
}

