/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.BoatTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.Displayer;
import com.sap.sailing.gwt.ui.client.Refresher;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;

public class BoatPanel
extends SimplePanel
implements FilterablePanelProvider<BoatDTO> {
    private final BoatTableWrapper<RefreshableMultiSelectionModel<BoatDTO>> boatTable;
    private final RefreshableMultiSelectionModel<BoatDTO> refreshableBoatSelectionModel;
    private Button allowReloadButton;
    private final Displayer<BoatDTO> boatsDisplayer = result -> this.refreshBoatList();

    public BoatPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages) {
        this.boatTable = new BoatTableWrapper(presenter.getSailingService(), presenter.getUserService(), presenter.getBoatsRefresher(), presenter.getCompetitorsRefresher(), stringMessages, presenter.getErrorReporter(), true, true, 100, true);
        this.refreshableBoatSelectionModel = (RefreshableMultiSelectionModel)this.boatTable.getSelectionModel();
        VerticalPanel mainPanel = new VerticalPanel();
        this.setWidget((Widget)mainPanel);
        mainPanel.setWidth("100%");
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(presenter.getUserService(), SecuredDomainType.BOAT);
        mainPanel.add((Widget)buttonPanel);
        Button refreshButton = buttonPanel.addUnsecuredAction(stringMessages.refresh(), () -> ((Refresher)presenter.getBoatsRefresher()).reloadAndCallFillAll());
        refreshButton.ensureDebugId("RefreshButton");
        this.allowReloadButton = buttonPanel.addUnsecuredAction(stringMessages.allowReload(), () -> this.boatTable.allowUpdate((Iterable)this.refreshableBoatSelectionModel.getSelectedSet()));
        this.refreshableBoatSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.allowReloadButton.setEnabled(!this.refreshableBoatSelectionModel.getSelectedSet().isEmpty());
        Button addBoatButton = buttonPanel.addCreateAction(stringMessages.add(), () -> this.openAddBoatDialog());
        addBoatButton.ensureDebugId("AddBoatButton");
        buttonPanel.addUnsecuredAction(stringMessages.selectAll(), () -> {
            for (BoatDTO b : this.boatTable.getDataProvider().getList()) {
                this.refreshableBoatSelectionModel.setSelected((Object)b, true);
            }
        });
        mainPanel.add((IsWidget)this.boatTable);
    }

    public Displayer<BoatDTO> getBoatsDisplayer() {
        return this.boatsDisplayer;
    }

    private void openAddBoatDialog() {
        this.boatTable.openEditBoatDialog(new BoatDTO(), null);
    }

    public void refreshBoatList() {
        this.boatTable.refreshBoatList(false, null);
    }

    public AbstractFilterablePanel<BoatDTO> getFilterablePanel() {
        return this.boatTable.getFilterField();
    }

    static /* synthetic */ RefreshableMultiSelectionModel access$0(BoatPanel boatPanel) {
        return boatPanel.refreshableBoatSelectionModel;
    }

    static /* synthetic */ Button access$1(BoatPanel boatPanel) {
        return boatPanel.allowReloadButton;
    }
}

