/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SingleSelectionModel;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.domain.common.racelog.tracking.MappableToDevice;
import com.sap.sailing.gwt.ui.adminconsole.BoatTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.TrackFileImportDeviceIdentifierTableWrapper;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.DeviceIdentifierDTO;
import com.sap.sailing.gwt.ui.shared.TrackFileImportDeviceIdentifierDTO;
import com.sap.sailing.gwt.ui.shared.TypedDeviceMappingDTO;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractRegattaLogSensorDataAddMappingsDialog
extends DataEntryDialog<Collection<TypedDeviceMappingDTO>> {
    private final String leaderboardName;
    private final SimplePanel importWidgetHolder;
    protected final TrackFileImportDeviceIdentifierTableWrapper deviceIdTable;
    private final BoatTableWrapper<RefreshableSingleSelectionModel<BoatDTO>> boatTable;
    private final CompetitorTableWrapper<RefreshableSingleSelectionModel<CompetitorDTO>> competitorTable;
    private final StringMessages stringMessages;
    private TrackFileImportDeviceIdentifierDTO deviceToSelect;
    private CompetitorWithBoatDTO compToSelect;
    private BoatDTO boatToSelect;
    private boolean inInstableTransitionState = false;

    public AbstractRegattaLogSensorDataAddMappingsDialog(SailingServiceWriteAsync sailingServiceWrite, UserService userService, ErrorReporter errorReporter, StringMessages stringMessages, String leaderboardName, DataEntryDialog.DialogCallback<Collection<TypedDeviceMappingDTO>> callback) {
        super(stringMessages.add(stringMessages.deviceMappings()), stringMessages.add(stringMessages.deviceMappings()), stringMessages.add(), stringMessages.cancel(), (DataEntryDialog.Validator)new /* Unavailable Anonymous Inner Class!! */, true, callback);
        this.stringMessages = stringMessages;
        this.deviceIdTable = new TrackFileImportDeviceIdentifierTableWrapper(sailingServiceWrite, stringMessages, errorReporter);
        this.deviceIdTable.removeTrackNameColumn();
        this.importWidgetHolder = new SimplePanel();
        ((RefreshableSingleSelectionModel)this.deviceIdTable.getSelectionModel()).addSelectionChangeHandler(event -> this.deviceSelectionChanged((TrackFileImportDeviceIdentifierDTO)((RefreshableSingleSelectionModel)this.deviceIdTable.getSelectionModel()).getSelectedObject()));
        this.boatTable = new BoatTableWrapper(sailingServiceWrite, userService, null, null, stringMessages, errorReporter, false, true, false);
        this.competitorTable = new CompetitorTableWrapper(sailingServiceWrite, userService, null, null, stringMessages, errorReporter, false, true, false, false);
        ((RefreshableSingleSelectionModel)this.boatTable.getSelectionModel()).addSelectionChangeHandler(event -> {
            this.mappedToSelectionChanged((MappableToDevice)((RefreshableSingleSelectionModel)this.boatTable.getSelectionModel()).getSelectedObject());
            this.validateAndUpdate();
        });
        ((RefreshableSingleSelectionModel)this.competitorTable.getSelectionModel()).addSelectionChangeHandler(event -> {
            this.mappedToSelectionChanged((MappableToDevice)((RefreshableSingleSelectionModel)this.competitorTable.getSelectionModel()).getSelectedObject());
            this.validateAndUpdate();
        });
        this.leaderboardName = leaderboardName;
        this.getBoatRegistrations((SailingServiceAsync)sailingServiceWrite, errorReporter);
        this.getCompetitorRegistrations((SailingServiceAsync)sailingServiceWrite, errorReporter);
    }

    private void getBoatRegistrations(SailingServiceAsync sailingService, ErrorReporter errorReporter) {
        sailingService.getBoatRegistrationsForLeaderboard(this.leaderboardName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void getCompetitorRegistrations(SailingServiceAsync sailingService, ErrorReporter errorReporter) {
        sailingService.getCompetitorRegistrationsForLeaderboard(this.leaderboardName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected Widget getAdditionalWidget() {
        HorizontalPanel panel = new HorizontalPanel();
        VerticalPanel leftPanel = new VerticalPanel();
        VerticalPanel tablesPanel = new VerticalPanel();
        CaptionPanel competitorsPanel = new CaptionPanel(this.stringMessages.competitor());
        CaptionPanel boatsPanel = new CaptionPanel(this.stringMessages.boat());
        leftPanel.add((Widget)this.importWidgetHolder);
        leftPanel.add((IsWidget)this.deviceIdTable);
        panel.add((Widget)leftPanel);
        panel.add((Widget)tablesPanel);
        tablesPanel.add((Widget)boatsPanel);
        tablesPanel.add((Widget)competitorsPanel);
        boatsPanel.setContentWidget(this.boatTable.asWidget());
        competitorsPanel.setContentWidget(this.competitorTable.asWidget());
        return panel;
    }

    protected abstract String getSelectedImporterType();

    protected Collection<TypedDeviceMappingDTO> getResult() {
        ArrayList<TypedDeviceMappingDTO> result = new ArrayList<TypedDeviceMappingDTO>();
        String dataType = this.getSelectedImporterType();
        for (Map.Entry deviceEntry : this.deviceIdTable.getMappings().entrySet()) {
            TrackFileImportDeviceIdentifierDTO device = (TrackFileImportDeviceIdentifierDTO)deviceEntry.getKey();
            DeviceIdentifierDTO deviceIdDto = new DeviceIdentifierDTO("FILE", device.uuidAsString);
            MappableToDevice mappedTo = (MappableToDevice)this.deviceIdTable.getMappings().get(device);
            result.add(new TypedDeviceMappingDTO(deviceIdDto, device.from, device.to, mappedTo, null, dataType));
        }
        return result;
    }

    protected void setImportWidget(Widget importWidget) {
        this.importWidgetHolder.setWidget(importWidget);
    }

    private static <T> void selectOrClear(SingleSelectionModel<T> selectionModel, T object) {
        if (object == null) {
            selectionModel.clear();
        } else {
            selectionModel.setSelected(object, true);
        }
    }

    private void select() {
        if (this.inInstableTransitionState) {
            if (((RefreshableSingleSelectionModel)this.deviceIdTable.getSelectionModel()).getSelectedObject() == this.deviceToSelect && ((RefreshableSingleSelectionModel)this.competitorTable.getSelectionModel()).getSelectedObject() == this.compToSelect && ((RefreshableSingleSelectionModel)this.boatTable.getSelectionModel()).getSelectedObject() == this.boatToSelect) {
                this.inInstableTransitionState = false;
            }
        } else {
            this.inInstableTransitionState = true;
            AbstractRegattaLogSensorDataAddMappingsDialog.selectOrClear((SingleSelectionModel)((SingleSelectionModel)this.deviceIdTable.getSelectionModel()), (Object)this.deviceToSelect);
            AbstractRegattaLogSensorDataAddMappingsDialog.selectOrClear((SingleSelectionModel)((SingleSelectionModel)this.competitorTable.getSelectionModel()), (Object)this.compToSelect);
            AbstractRegattaLogSensorDataAddMappingsDialog.selectOrClear((SingleSelectionModel)((SingleSelectionModel)this.boatTable.getSelectionModel()), (Object)this.boatToSelect);
        }
    }

    private void mappedToSelectionChanged(MappableToDevice mappedTo) {
        if (!this.inInstableTransitionState) {
            this.deviceIdTable.setMappedObjectForSelectedDevice(mappedTo);
            if (mappedTo instanceof CompetitorWithBoatDTO) {
                this.compToSelect = (CompetitorWithBoatDTO)mappedTo;
                this.boatToSelect = null;
            } else if (mappedTo instanceof BoatDTO) {
                this.compToSelect = null;
                this.boatToSelect = (BoatDTO)mappedTo;
            }
        }
        this.select();
        this.validateAndUpdate();
    }

    private void deviceSelectionChanged(TrackFileImportDeviceIdentifierDTO deviceId) {
        if (!this.inInstableTransitionState) {
            this.deviceToSelect = deviceId;
            this.compToSelect = null;
            this.boatToSelect = null;
            if (deviceId != null) {
                MappableToDevice mappedTo = this.deviceIdTable.getMappedObjectForDeviceId(deviceId);
                if (mappedTo instanceof CompetitorWithBoatDTO) {
                    this.compToSelect = (CompetitorWithBoatDTO)mappedTo;
                } else if (mappedTo instanceof BoatDTO) {
                    this.boatToSelect = (BoatDTO)mappedTo;
                }
            }
        }
        this.select();
    }

    static /* synthetic */ BoatTableWrapper access$1(AbstractRegattaLogSensorDataAddMappingsDialog abstractRegattaLogSensorDataAddMappingsDialog) {
        return abstractRegattaLogSensorDataAddMappingsDialog.boatTable;
    }

    static /* synthetic */ CompetitorTableWrapper access$2(AbstractRegattaLogSensorDataAddMappingsDialog abstractRegattaLogSensorDataAddMappingsDialog) {
        return abstractRegattaLogSensorDataAddMappingsDialog.competitorTable;
    }
}

