/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.actions;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.shared.CompetitorsRaceDataDTO;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.async.TimeRangeAsyncAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class GetCompetitorsRaceDataAction
implements TimeRangeAsyncAction<CompetitorsRaceDataDTO, Util.Pair<CompetitorDTO, DetailType>> {
    private final SailingServiceAsync sailingService;
    private final RegattaAndRaceIdentifier raceIdentifier;
    private final List<CompetitorDTO> competitors;
    private final Date fromDate;
    private final Date toDate;
    private final long stepSizeInMs;
    private final DetailType detailType;
    private final String leaderboardGroupName;
    private final UUID leaderboardGroupId;
    private final String leaderboardName;

    public GetCompetitorsRaceDataAction(SailingServiceAsync sailingService, RegattaAndRaceIdentifier raceIdentifier, List<CompetitorDTO> competitors, Date fromDate, Date toDate, long stepSizeInMs, DetailType detailType, String leaderboardGroupName, UUID leaderboardGroupId, String leaderboardName) {
        this.sailingService = sailingService;
        this.raceIdentifier = raceIdentifier;
        this.competitors = competitors;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.stepSizeInMs = stepSizeInMs;
        this.detailType = detailType;
        this.leaderboardGroupName = leaderboardGroupName;
        this.leaderboardGroupId = leaderboardGroupId;
        this.leaderboardName = leaderboardName;
    }

    public void execute(Map<Util.Pair<CompetitorDTO, DetailType>, TimeRange> timeRanges, AsyncCallback<CompetitorsRaceDataDTO> callback) {
        if (timeRanges != null && !timeRanges.isEmpty()) {
            DetailType detailType = null;
            ArrayList<CompetitorDTO> competitors = new ArrayList<CompetitorDTO>();
            TimeRange timeRange = null;
            for (Map.Entry<Util.Pair<CompetitorDTO, DetailType>, TimeRange> e : timeRanges.entrySet()) {
                competitors.add((CompetitorDTO)e.getKey().getA());
                if (detailType == null) {
                    detailType = (DetailType)e.getKey().getB();
                } else if (detailType != e.getKey().getB()) {
                    throw new IllegalArgumentException("The detail types must be the same; got " + detailType + " and " + e.getKey().getB());
                }
                TimeRange timeRange2 = timeRange = timeRange == null ? e.getValue() : timeRange.extend(e.getValue());
            }
            GWT.log((String)("Calling getCompetitorsRaceData(" + this.raceIdentifier + ", " + new ArrayList<Util.Pair<CompetitorDTO, DetailType>>(timeRanges.keySet()) + ", " + timeRange.from() + ", " + timeRange.to() + ", " + this.stepSizeInMs + ", " + detailType + ", " + this.leaderboardGroupName + ", " + this.leaderboardGroupId + ", " + this.leaderboardName));
            this.sailingService.getCompetitorsRaceData(this.raceIdentifier, competitors, timeRange.from().asDate(), timeRange.to().asDate(), this.stepSizeInMs, detailType, this.leaderboardGroupName, this.leaderboardGroupId, this.leaderboardName, callback);
        }
    }

    public Map<Util.Pair<CompetitorDTO, DetailType>, TimeRange> getTimeRanges() {
        TimeRange timeRange = TimeRange.create((TimePoint)TimePoint.of((Date)this.fromDate), (TimePoint)TimePoint.of((Date)this.toDate));
        HashMap<Util.Pair<CompetitorDTO, DetailType>, TimeRange> result = new HashMap<Util.Pair<CompetitorDTO, DetailType>, TimeRange>();
        for (CompetitorDTO competitor : this.competitors) {
            result.put((Util.Pair<CompetitorDTO, DetailType>)new Util.Pair((Object)competitor, (Object)this.detailType), timeRange);
        }
        return result;
    }
}

