/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.places.subscription;

import com.google.gwt.activity.shared.AbstractActivity;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import com.sap.sailing.gwt.home.shared.places.subscription.SubscriptionClientFactory;
import com.sap.sailing.gwt.home.shared.places.subscription.SubscriptionPlace;
import com.sap.sailing.gwt.home.shared.places.subscription.SubscriptionView;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.shared.subscription.InvalidSubscriptionProviderException;
import com.sap.sse.security.ui.authentication.AuthenticationContextEvent;
import com.sap.sse.security.ui.authentication.app.AuthenticationContext;
import com.sap.sse.security.ui.client.subscription.SubscribeView;
import com.sap.sse.security.ui.shared.subscription.SubscriptionPlanDTO;

public abstract class AbstractSubscriptionActivity
extends AbstractActivity
implements SubscriptionView.Presenter {
    private final SubscriptionClientFactory clientFactory;
    private final SubscriptionPlace subscriptionsPlace;
    private final SubscriptionView view;

    protected AbstractSubscriptionActivity(SubscriptionPlace place, SubscriptionClientFactory clientFactory) {
        this.clientFactory = clientFactory;
        this.subscriptionsPlace = place;
        this.view = clientFactory.createSubscriptionsView();
    }

    public void start(AcceptsOneWidget panel, EventBus eventBus) {
        Window.setTitle((String)this.subscriptionsPlace.getTitle());
        this.view.setPresenter((SubscriptionView.Presenter)this);
        eventBus.addHandler(AuthenticationContextEvent.TYPE, (EventHandler)((AuthenticationContextEvent.Handler)event -> this.renderSubscriptions(eventBus)));
        panel.setWidget((IsWidget)this.view);
        this.renderSubscriptions(eventBus);
    }

    private void renderSubscriptions(EventBus eventBus) {
        try {
            this.clientFactory.getSubscriptionServiceFactory().getDefaultAsyncService().getAllSubscriptionPlans((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InvalidSubscriptionProviderException exc) {
            this.onInvalidSubscriptionProviderError(exc);
        }
    }

    public void startSubscription(String priceId) {
        try {
            this.clientFactory.getSubscriptionServiceFactory().getDefaultProvider().getSubscriptionViewPresenter().startCheckout(priceId, (SubscribeView)this.view, () -> this.clientFactory.getUserService().updateUser(true));
        }
        catch (InvalidSubscriptionProviderException e) {
            this.view.onOpenCheckoutError(e.toString());
        }
    }

    public AuthenticationContext getAuthenticationContext() {
        return this.clientFactory.getAuthenticationManager().getAuthenticationContext();
    }

    private boolean checkIfUserIsOwnerOfThePlan(SubscriptionPlanDTO plan) {
        return plan.isUserSubscribedToPlan();
    }

    private boolean checkIfUserIsSubscribedToPlanCategory(SubscriptionPlanDTO plan) {
        return plan.isUserSubscribedToAllPlanCategories();
    }

    private boolean checkIfUserWasAlreadySubscribedToOneTimePlan(SubscriptionPlanDTO plan) {
        return plan.isUserWasAlreadySubscribedToOneTimePlan();
    }

    private boolean checkIfPlanWouldBeAnUpgrade(SubscriptionPlanDTO plan) {
        return plan.isOneOfTheUserSubscriptionsIsCoveredByPlan();
    }

    private void onInvalidSubscriptionProviderError(InvalidSubscriptionProviderException exc) {
        this.clientFactory.createErrorView(StringMessages.INSTANCE.errorInvalidSubscritionProvider(exc.getMessage()), (Throwable)exc);
    }

    public boolean isMailVerificationRequired() {
        UserDTO currentUser = this.clientFactory.getUserService().getCurrentUser();
        return currentUser == null || !currentUser.isEmailValidated();
    }

    static /* synthetic */ SubscriptionView access$0(AbstractSubscriptionActivity abstractSubscriptionActivity) {
        return abstractSubscriptionActivity.view;
    }

    static /* synthetic */ boolean access$1(AbstractSubscriptionActivity abstractSubscriptionActivity, SubscriptionPlanDTO subscriptionPlanDTO) {
        return abstractSubscriptionActivity.checkIfUserIsOwnerOfThePlan(subscriptionPlanDTO);
    }

    static /* synthetic */ boolean access$2(AbstractSubscriptionActivity abstractSubscriptionActivity, SubscriptionPlanDTO subscriptionPlanDTO) {
        return abstractSubscriptionActivity.checkIfUserIsSubscribedToPlanCategory(subscriptionPlanDTO);
    }

    static /* synthetic */ boolean access$3(AbstractSubscriptionActivity abstractSubscriptionActivity, SubscriptionPlanDTO subscriptionPlanDTO) {
        return abstractSubscriptionActivity.checkIfUserWasAlreadySubscribedToOneTimePlan(subscriptionPlanDTO);
    }

    static /* synthetic */ SubscriptionPlace access$4(AbstractSubscriptionActivity abstractSubscriptionActivity) {
        return abstractSubscriptionActivity.subscriptionsPlace;
    }

    static /* synthetic */ boolean access$5(AbstractSubscriptionActivity abstractSubscriptionActivity, SubscriptionPlanDTO subscriptionPlanDTO) {
        return abstractSubscriptionActivity.checkIfPlanWouldBeAnUpgrade(subscriptionPlanDTO);
    }

    static /* synthetic */ SubscriptionClientFactory access$6(AbstractSubscriptionActivity abstractSubscriptionActivity) {
        return abstractSubscriptionActivity.clientFactory;
    }
}

