/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.partials.regattacompetition;

import com.sap.sailing.gwt.home.communication.event.RaceCompetitionFormatFleetDTO;
import com.sap.sailing.gwt.home.communication.event.RaceCompetitionFormatSeriesDTO;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorDTO;
import com.sap.sailing.gwt.home.communication.race.SimpleRaceMetadataDTO;
import com.sap.sailing.gwt.home.shared.partials.filter.FilterValueChangeHandler;
import com.sap.sailing.gwt.home.shared.partials.filter.FilterValueProvider;
import com.sap.sailing.gwt.home.shared.partials.regattacompetition.RegattaCompetitionView;
import com.sap.sailing.gwt.home.shared.refresh.RefreshableWidget;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.gwt.dispatch.shared.commands.ListResult;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class RegattaCompetitionPresenter
implements RefreshableWidget<ListResult<RaceCompetitionFormatSeriesDTO>>,
FilterValueProvider<SimpleCompetitorDTO>,
FilterValueChangeHandler<SimpleRaceMetadataDTO> {
    private final RegattaCompetitionView view;
    private Filter<SimpleRaceMetadataDTO> latestRacesByCompetitorFilter;
    private Map<RegattaCompetitionView.RegattaCompetitionSeriesView, Map<RegattaCompetitionView.RegattaCompetitionFleetView, Map<RegattaCompetitionView.RegattaCompetitionRaceView, SimpleRaceMetadataDTO>>> structure = new HashMap();
    private final PaywallResolver paywallResolver;

    public RegattaCompetitionPresenter(RegattaCompetitionView view, PaywallResolver paywallResolver) {
        this.view = view;
        this.paywallResolver = paywallResolver;
    }

    public void setData(ListResult<RaceCompetitionFormatSeriesDTO> data) {
        this.view.clearContent();
        this.structure.clear();
        for (RaceCompetitionFormatSeriesDTO series : data.getValues()) {
            RegattaCompetitionView.RegattaCompetitionSeriesView seriesView = this.view.addSeriesView(series);
            HashMap fleetMap = new HashMap();
            this.structure.put(seriesView, fleetMap);
            for (RaceCompetitionFormatFleetDTO fleet : series.getFleets()) {
                RegattaCompetitionView.RegattaCompetitionFleetView fleetView = seriesView.addFleetView(fleet);
                fleetView.setNumberOfFleetsInSeries(series.getFleets().size());
                HashMap<RegattaCompetitionView.RegattaCompetitionRaceView, SimpleRaceMetadataDTO> raceMap = new HashMap<RegattaCompetitionView.RegattaCompetitionRaceView, SimpleRaceMetadataDTO>();
                fleetMap.put(fleetView, raceMap);
                for (SimpleRaceMetadataDTO race : fleet.getRaces()) {
                    String fleetName = fleet.getFleet().getFleetName();
                    RegattaCompetitionView.RegattaCompetitionRaceView raceView = fleetView.addRaceView(race, fleetName == null ? "Default" : fleetName, this);
                    raceMap.put(raceView, race);
                }
            }
            if (this.latestRacesByCompetitorFilter == null) continue;
            this.applyFilter(seriesView, this.latestRacesByCompetitorFilter);
        }
    }

    public void onFilterValueChanged(Filter<SimpleRaceMetadataDTO> filter) {
        this.latestRacesByCompetitorFilter = filter;
        for (RegattaCompetitionView.RegattaCompetitionSeriesView seriesView : this.structure.keySet()) {
            this.applyFilter(seriesView, this.latestRacesByCompetitorFilter);
        }
    }

    public Collection<SimpleCompetitorDTO> getFilterableValues() {
        HashSet<SimpleCompetitorDTO> filterableValues = new HashSet<SimpleCompetitorDTO>();
        for (Map series : this.structure.values()) {
            for (Map fleet : series.values()) {
                for (SimpleRaceMetadataDTO raceMetadata : fleet.values()) {
                    filterableValues.addAll(raceMetadata.getCompetitors());
                }
            }
        }
        return filterableValues;
    }

    private void applyFilter(RegattaCompetitionView.RegattaCompetitionSeriesView seriesView, Filter<SimpleRaceMetadataDTO> filter) {
        int unfilteredFleetCount = 0;
        Map fleetMap = (Map)this.structure.get(seriesView);
        for (Map.Entry fleetEntry : fleetMap.entrySet()) {
            boolean filterFleet = true;
            for (Map.Entry raceEntry : ((Map)fleetEntry.getValue()).entrySet()) {
                boolean filterRace = !filter.matches((Object)((SimpleRaceMetadataDTO)raceEntry.getValue()));
                ((RegattaCompetitionView.RegattaCompetitionRaceView)raceEntry.getKey()).doFilter(filterRace);
                filterFleet &= filterRace;
            }
            ((RegattaCompetitionView.RegattaCompetitionFleetView)fleetEntry.getKey()).doFilter(filterFleet);
            unfilteredFleetCount += filterFleet ? 0 : 1;
        }
        for (RegattaCompetitionView.RegattaCompetitionFleetView fleetView : fleetMap.keySet()) {
            fleetView.setNumberOfFleetsInSeries(unfilteredFleetCount);
        }
        seriesView.doFilter(unfilteredFleetCount == 0);
    }

    protected abstract String getRaceViewerURL(SimpleRaceMetadataDTO var1, String var2);

    protected abstract String getMapAndWindChartUrl(String var1, String var2, String var3);

    public PaywallResolver getPaywallResolver() {
        return this.paywallResolver;
    }
}

