/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.partials.countdown;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.HeadingElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.common.client.SharedResources;
import com.sap.sailing.gwt.home.communication.event.eventoverview.EventOverviewRaceTickerStageDTO;
import com.sap.sailing.gwt.home.communication.event.eventoverview.EventOverviewRegattaTickerStageDTO;
import com.sap.sailing.gwt.home.communication.event.eventoverview.EventOverviewTickerStageDTO;
import com.sap.sailing.gwt.home.shared.SharedHomeResources;
import com.sap.sailing.gwt.home.shared.partials.countdown.Countdown;
import com.sap.sailing.gwt.home.shared.partials.countdown.CountdownResources;
import com.sap.sailing.gwt.home.shared.partials.countdowntimer.CountdownTimer;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.media.MediaMenuIcon;
import com.sap.sse.gwt.client.media.TakedownNoticeService;
import com.sap.sse.security.ui.client.UserService;

/*
 * Exception performing whole class analysis ignored.
 */
public class Countdown
extends Composite {
    private static final StringMessages I18N = StringMessages.INSTANCE;
    private static final CountdownResources.LocalCss CSS = CountdownResources.INSTANCE.css();
    private static final SharedResources.MainCss MAIN_CSS = SharedResources.INSTANCE.mainCss();
    private static CountdownUiBinder uiBinder = (CountdownUiBinder)GWT.create(CountdownUiBinder.class);
    @UiField
    SimplePanel tickerContainer;
    @UiField
    HeadingElement countdownTitle;
    @UiField
    DivElement countdownInfo;
    @UiField
    HeadingElement infoTitle;
    @UiField(provided=true)
    NavigationAnchor navigationButton;
    @UiField
    DivElement image;
    @UiField(provided=true)
    MediaMenuIcon imageMenuButton;

    public Countdown(CountdownNavigationProvider navigationProvider, UserService takedownNoticeService) {
        CSS.ensureInjected();
        this.navigationButton = new NavigationAnchor(this, navigationProvider, null);
        this.imageMenuButton = new MediaMenuIcon((TakedownNoticeService)takedownNoticeService, "takedownRequestForImageOnEventStage");
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public void setData(EventOverviewTickerStageDTO data) {
        String stageImageUrl = data.getStageImageUrl() != null ? data.getStageImageUrl() : SharedHomeResources.INSTANCE.defaultStageEventTeaserImage().getSafeUri().asString();
        this.image.getStyle().setBackgroundImage("url(\"" + stageImageUrl + "\")");
        this.navigationButton.removeStyleName(MAIN_CSS.buttonred());
        this.navigationButton.removeStyleName(MAIN_CSS.buttonprimary());
        if (data instanceof EventOverviewRaceTickerStageDTO) {
            this.updateUi(I18N.nextRaceStartingIn(), data.getTickerInfo());
            NavigationAnchor.access$1((NavigationAnchor)this.navigationButton, (EventOverviewRaceTickerStageDTO)((EventOverviewRaceTickerStageDTO)data));
        } else if (data instanceof EventOverviewRegattaTickerStageDTO) {
            if (data.getStartTime() != null) {
                this.updateUi(I18N.startingIn(data.getTickerInfo()), data.getTickerInfo());
            }
            NavigationAnchor.access$2((NavigationAnchor)this.navigationButton, (EventOverviewRegattaTickerStageDTO)((EventOverviewRegattaTickerStageDTO)data));
        } else {
            this.updateUi(data.getTickerInfo() != null && data.getStartTime() != null ? I18N.startingIn(data.getTickerInfo()) : null, null);
        }
        if (data.getStartTime() != null) {
            this.tickerContainer.setWidget((Widget)new CountdownTimer(data.getStartTime(), true));
        } else {
            this.tickerContainer.setWidget(null);
        }
        this.imageMenuButton.setData(data.getTickerInfo(), stageImageUrl);
    }

    private void updateUi(String title, String info) {
        this.countdownTitle.setInnerText(title);
        this.infoTitle.setInnerText(info);
        this.countdownInfo.getStyle().setDisplay(info != null ? Style.Display.BLOCK : Style.Display.NONE);
    }

    @UiHandler(value={"navigationButton"})
    void handleNavigationButtonClick(ClickEvent event) {
        NavigationAnchor.access$3((NavigationAnchor)this.navigationButton, (ClickEvent)event);
    }

    static /* synthetic */ SharedResources.MainCss access$0() {
        return MAIN_CSS;
    }

    static /* synthetic */ StringMessages access$1() {
        return I18N;
    }
}

