/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.places;

import com.sap.sailing.gwt.home.communication.event.EventAndLeaderboardReferenceWithStateDTO;
import com.sap.sailing.gwt.home.communication.event.EventMetadataDTO;
import com.sap.sailing.gwt.home.communication.eventview.RegattaMetadataDTO;
import com.sap.sailing.gwt.home.mobile.partials.quickfinder.Quickfinder;
import com.sap.sailing.gwt.home.mobile.places.QuickfinderPresenter;
import com.sap.sailing.gwt.home.mobile.places.RegattaLeaderboardNavigationProvider;
import com.sap.sailing.gwt.home.mobile.places.RegattaOverviewNavigationProvider;
import com.sap.sailing.gwt.home.mobile.places.RegattaRacesNavigationProvider;
import com.sap.sailing.gwt.home.mobile.places.SeriesEventLeaderboardOverviewNavigationProvider;
import com.sap.sailing.gwt.home.mobile.places.SeriesEventRacesNavigationProvider;
import com.sap.sailing.gwt.home.mobile.places.SeriesLeaderboardNavigationProvider;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventReferenceDTO;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class QuickfinderPresenter {
    private static final StringMessages MSG = StringMessages.INSTANCE;

    public static QuickfinderPresenter getForRegattaLeaderboards(Quickfinder quickfinder, RegattaLeaderboardNavigationProvider navigator, Map<String, Set<RegattaMetadataDTO>> regattasByLeaderboardGroupName) {
        return new QuickfinderPresenter(quickfinder, MSG.resultsQuickfinder(), (RegattaPlaceNaviationProvider)new /* Unavailable Anonymous Inner Class!! */, regattasByLeaderboardGroupName);
    }

    public static QuickfinderPresenter getForRegattaRaces(Quickfinder quickfinder, RegattaRacesNavigationProvider navigator, Map<String, Set<RegattaMetadataDTO>> regattasByLeaderboardGroupName) {
        return new QuickfinderPresenter(quickfinder, MSG.racesQuickfinder(), (RegattaPlaceNaviationProvider)new /* Unavailable Anonymous Inner Class!! */, regattasByLeaderboardGroupName);
    }

    public static QuickfinderPresenter getForRegattaOverview(Quickfinder quickfinder, RegattaOverviewNavigationProvider navigator, Map<String, Set<RegattaMetadataDTO>> regattasByLeaderboardGroupName) {
        return new QuickfinderPresenter(quickfinder, MSG.regattaQuickfinder(), (RegattaPlaceNaviationProvider)new /* Unavailable Anonymous Inner Class!! */, regattasByLeaderboardGroupName);
    }

    public static <T extends EventAndLeaderboardReferenceWithStateDTO> QuickfinderPresenter getForSeriesLeaderboards(Quickfinder quickfinder, String seriesName, SeriesLeaderboardNavigationProvider navigator, Collection<T> eventsOfSeries) {
        return new QuickfinderPresenter(quickfinder, MSG.resultsQuickfinder(), (SeriesEventPlaceNaviationProvider)new /* Unavailable Anonymous Inner Class!! */, seriesName, eventsOfSeries);
    }

    public static <T extends EventReferenceDTO> QuickfinderPresenter getForSeriesEventRaces(Quickfinder quickfinder, String seriesName, SeriesEventRacesNavigationProvider navigator, Collection<T> eventsOfSeries) {
        return new QuickfinderPresenter(quickfinder, MSG.racesQuickfinder(), (SeriesEventPlaceNaviationProvider)new /* Unavailable Anonymous Inner Class!! */, seriesName, eventsOfSeries);
    }

    public static <T extends EventAndLeaderboardReferenceWithStateDTO> QuickfinderPresenter getForSeriesEventOverview(Quickfinder quickfinder, String seriesName, SeriesEventLeaderboardOverviewNavigationProvider navigator, Collection<T> eventsOfSeries) {
        return new QuickfinderPresenter(quickfinder, MSG.eventQuickfinder(), (SeriesEventPlaceNaviationProvider)new /* Unavailable Anonymous Inner Class!! */, seriesName, eventsOfSeries);
    }

    private <T extends EventReferenceDTO> QuickfinderPresenter(Quickfinder quickfinder, String placeholder, SeriesEventPlaceNaviationProvider<T> provider, String seriesName, Collection<T> eventsOfSeries) {
        if (eventsOfSeries == null) {
            quickfinder.removeFromParent();
            return;
        }
        quickfinder.addPlaceholderItem(placeholder);
        PlaceNavigation overallPlaceNavigation = provider.getOverallPlaceNavigation();
        if (overallPlaceNavigation != null) {
            quickfinder.addItemToGroup(seriesName, MSG.overallLeaderboardSelection(), overallPlaceNavigation);
        }
        for (EventReferenceDTO eventOfSeries : eventsOfSeries) {
            String displayName = eventOfSeries.getDisplayName();
            if (eventOfSeries instanceof EventMetadataDTO) {
                displayName = ((EventMetadataDTO)eventOfSeries).getLocationOrDisplayName();
            }
            quickfinder.addItemToGroup(seriesName, displayName, provider.getPlaceNavigation((Object)eventOfSeries));
        }
    }

    private QuickfinderPresenter(Quickfinder quickfinder, String placeholder, RegattaPlaceNaviationProvider provider, Map<String, Set<RegattaMetadataDTO>> regattasByLeaderboardGroupName) {
        if (regattasByLeaderboardGroupName == null) {
            quickfinder.removeFromParent();
            return;
        }
        quickfinder.addPlaceholderItem(placeholder);
        for (Map.Entry<String, Set<RegattaMetadataDTO>> entry : regattasByLeaderboardGroupName.entrySet()) {
            String leaderboardGroupName = entry.getKey() == null ? MSG.regattas() : entry.getKey();
            for (RegattaMetadataDTO regattaMetadata : entry.getValue()) {
                quickfinder.addItemToGroup(leaderboardGroupName, regattaMetadata.getDisplayName(), provider.getPlaceNavigation(regattaMetadata.getId()));
            }
        }
    }
}

