/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.regattaheader;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.common.client.BoatClassImageResolver;
import com.sap.sailing.gwt.home.communication.eventview.RegattaMetadataDTO;
import com.sap.sailing.gwt.home.desktop.partials.regattaheader.RegattaHeader;
import com.sap.sailing.gwt.home.desktop.partials.regattaheader.RegattaHeaderBody;
import com.sap.sailing.gwt.home.desktop.partials.regattaheader.RegattaHeaderBubbleContentLegend;
import com.sap.sailing.gwt.home.desktop.partials.regattaheader.RegattaHeaderResources;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.home.shared.partials.bubble.Bubble;
import com.sap.sailing.gwt.home.shared.partials.bubble.BubbleContentBoatClass;

public class RegattaHeader
extends Composite {
    private static RegattaHeaderUiBinder uiBinder = (RegattaHeaderUiBinder)GWT.create(RegattaHeaderUiBinder.class);
    @UiField
    RegattaHeaderResources local_res;
    @UiField
    AnchorElement logoUi;
    @UiField
    AnchorElement headerBodyUi;
    @UiField
    AnchorElement headerArrowUi;
    @UiField
    AnchorElement dataIndicatorsUi;
    @UiField
    DivElement gpsDataIndicatorUi;
    @UiField
    DivElement windDataIndicatorUi;
    @UiField
    DivElement videoDataIndicatorUi;
    @UiField
    DivElement audioDataIndicatorUi;

    public RegattaHeader(RegattaMetadataDTO regattaMetadata, boolean showStateMarker) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        ImageResource logo = BoatClassImageResolver.getBoatClassIconResource((String)regattaMetadata.getBoatClass());
        this.logoUi.getStyle().setBackgroundImage("url('" + logo.getSafeUri().asString() + "')");
        this.headerBodyUi.appendChild((Node)new RegattaHeaderBody(regattaMetadata, showStateMarker).getElement());
        this.initDataIndicators(regattaMetadata.getRaceDataInfo());
        this.addBoatClassBubble(regattaMetadata.getBoatClass());
        this.addLegendBubble(regattaMetadata.getRaceDataInfo());
    }

    private void addLegendBubble(RegattaMetadataDTO.RaceDataInfo raceDataInfo) {
        RegattaHeaderBubbleContentLegend content = new RegattaHeaderBubbleContentLegend(raceDataInfo);
        Bubble.DefaultPresenter presenter = new Bubble.DefaultPresenter((IsWidget)content, (Element)this.getElement(), (Element)this.dataIndicatorsUi, Bubble.Direction.LEFT);
        presenter.registerTarget((Element)this.dataIndicatorsUi);
    }

    private void addBoatClassBubble(String boatClassName) {
        BubbleContentBoatClass content = new BubbleContentBoatClass(boatClassName);
        Bubble.DefaultPresenter presenter = new Bubble.DefaultPresenter((IsWidget)content, (Element)this.getElement(), (Element)this.logoUi, Bubble.Direction.RIGHT);
        presenter.registerTarget((Element)this.logoUi);
    }

    public void setRegattaNavigation(PlaceNavigation<?> placeNavigation) {
        this.headerArrowUi.getStyle().clearDisplay();
        this.dataIndicatorsUi.addClassName(this.local_res.css().regattaheader_indicators_next_to_arrow());
        placeNavigation.configureAnchorElement(this.logoUi);
        placeNavigation.configureAnchorElement(this.headerBodyUi);
        placeNavigation.configureAnchorElement(this.headerArrowUi);
    }

    public void setRegattaRacesNavigation(PlaceNavigation<?> placeNavigation) {
        placeNavigation.configureAnchorElement(this.dataIndicatorsUi);
    }

    private void initDataIndicators(RegattaMetadataDTO.RaceDataInfo raceDataInfo) {
        String disabledStyle = this.local_res.css().regattaheader_indicator_disabled();
        UIObject.setStyleName((Element)this.gpsDataIndicatorUi, (String)disabledStyle, (!raceDataInfo.hasGPSData() ? 1 : 0) != 0);
        UIObject.setStyleName((Element)this.windDataIndicatorUi, (String)disabledStyle, (!raceDataInfo.hasWindData() ? 1 : 0) != 0);
        UIObject.setStyleName((Element)this.videoDataIndicatorUi, (String)disabledStyle, (!raceDataInfo.hasVideoData() ? 1 : 0) != 0);
        UIObject.setStyleName((Element)this.audioDataIndicatorUi, (String)disabledStyle, (!raceDataInfo.hasAudioData() ? 1 : 0) != 0);
    }
}

