/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.old.multileaderboard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.gwt.home.desktop.partials.old.EventRegattaLeaderboardResources;
import com.sap.sailing.gwt.home.desktop.partials.old.multileaderboard.OldMultiLeaderboard;
import com.sap.sailing.gwt.ui.client.DebugIdHelper;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.MultiLeaderboardProxyPanel;
import com.sap.sailing.gwt.ui.leaderboard.MultiRaceLeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.ScoringSchemeTypeFormatter;
import com.sap.sailing.gwt.ui.leaderboard.SelectedLeaderboardChangeListener;
import com.sap.sse.gwt.client.DateAndTimeFormatterUtil;
import com.sap.sse.gwt.client.controls.busyindicator.BusyIndicator;
import com.sap.sse.gwt.client.controls.busyindicator.BusyStateChangeListener;
import com.sap.sse.gwt.client.player.Timer;
import java.util.Date;

public class OldMultiLeaderboard
extends Composite
implements SelectedLeaderboardChangeListener<MultiRaceLeaderboardPanel>,
BusyStateChangeListener {
    private static OldMultiLeaderboardUiBinder uiBinder = (OldMultiLeaderboardUiBinder)GWT.create(OldMultiLeaderboardUiBinder.class);
    @UiField
    HTMLPanel oldMultiLeaderboardPanel;
    @UiField
    Anchor settingsAnchor;
    @UiField
    Anchor autoRefreshAnchor;
    @UiField
    Anchor fullscreenAnchor;
    @UiField
    DivElement lastScoringUpdateTimeDiv;
    @UiField
    DivElement lastScoringUpdateTextDiv;
    @UiField
    DivElement lastScoringCommentDiv;
    @UiField
    DivElement scoringSchemeDiv;
    @UiField
    BusyIndicator busyIndicator;
    @UiField
    EventRegattaLeaderboardResources local_res;
    private MultiLeaderboardProxyPanel multiLeaderboardPanel = null;
    private Timer autoRefreshTimer;
    private final OldMultiLeaderboardDelegate delegate;
    private MultiRaceLeaderboardPanel lastSelectedLeaderboardPanel;

    public OldMultiLeaderboard() {
        this(null);
    }

    public OldMultiLeaderboard(OldMultiLeaderboardDelegate delegate) {
        EventRegattaLeaderboardResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.settingsAnchor.setTitle(StringMessages.INSTANCE.settings());
        this.autoRefreshAnchor.setTitle(StringMessages.INSTANCE.refresh());
        this.fullscreenAnchor.setTitle(StringMessages.INSTANCE.openFullscreenView());
        this.delegate = delegate;
        this.setupFullscreenDelegate();
        this.lastSelectedLeaderboardPanel = null;
    }

    private void setupFullscreenDelegate() {
        if (this.delegate == null) {
            this.fullscreenAnchor.removeFromParent();
            return;
        }
        this.delegate.addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.delegate.getSettingsControl().setTitle(StringMessages.INSTANCE.settings());
        this.delegate.getSettingsControl().addHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, (GwtEvent.Type)ClickEvent.getType());
        this.delegate.getAutoRefreshControl().setTitle(StringMessages.INSTANCE.refresh());
        this.delegate.getAutoRefreshControl().addHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, (GwtEvent.Type)ClickEvent.getType());
    }

    public void turnOnAutoPlay() {
        if (this.autoRefreshTimer.getPlayState() != Timer.PlayStates.Playing) {
            this.autoRefreshTimer.setPlayMode(Timer.PlayModes.Live);
        }
        this.autoRefreshAnchor.addStyleName(this.local_res.css().regattaleaderboard_meta_reload_live());
        if (this.delegate != null) {
            this.delegate.getAutoRefreshControl().addStyleName(this.local_res.css().regattaleaderboard_meta_reload_live());
        }
    }

    @UiHandler(value={"autoRefreshAnchor"})
    void toogleAutoRefreshClicked(ClickEvent event) {
        if (this.autoRefreshTimer != null) {
            this.autoRefreshAnchor.removeStyleName(this.local_res.css().regattaleaderboard_meta_reload_live());
            this.autoRefreshAnchor.removeStyleName(this.local_res.css().regattaleaderboard_meta_reload_playing());
            if (this.delegate != null) {
                this.delegate.getAutoRefreshControl().removeStyleName(this.local_res.css().regattaleaderboard_meta_reload_live());
                this.delegate.getAutoRefreshControl().removeStyleName(this.local_res.css().regattaleaderboard_meta_reload_playing());
            }
            if (this.autoRefreshTimer.getPlayState() == Timer.PlayStates.Playing) {
                this.autoRefreshTimer.pause();
            } else {
                this.autoRefreshTimer.setPlayMode(Timer.PlayModes.Live);
                this.autoRefreshAnchor.addStyleName(this.local_res.css().regattaleaderboard_meta_reload_live());
                if (this.delegate != null) {
                    this.delegate.getAutoRefreshControl().addStyleName(this.local_res.css().regattaleaderboard_meta_reload_live());
                }
            }
        }
    }

    @UiHandler(value={"settingsAnchor"})
    void settingsClicked(ClickEvent event) {
        if (this.multiLeaderboardPanel != null) {
            String componentName = this.multiLeaderboardPanel.getLocalizedShortName();
            String debugIdPrefix = DebugIdHelper.createDebugId((String)componentName);
            4 dialog = new /* Unavailable Anonymous Inner Class!! */;
            dialog.ensureDebugId(String.valueOf(debugIdPrefix) + "SettingsDialog");
            dialog.show();
        }
    }

    @UiHandler(value={"fullscreenAnchor"})
    void fullscreenClicked(ClickEvent event) {
        if (this.multiLeaderboardPanel != null && this.delegate != null) {
            this.multiLeaderboardPanel.removeFromParent();
            this.delegate.setLeaderboardPanel((Widget)this.multiLeaderboardPanel);
        }
    }

    public void setMultiLeaderboard(MultiLeaderboardProxyPanel multiLeaderboardPanel, Timer timer) {
        this.autoRefreshTimer = timer;
        this.multiLeaderboardPanel = multiLeaderboardPanel;
        this.multiLeaderboardPanel.addSelectedLeaderboardChangeListener((SelectedLeaderboardChangeListener)this);
        this.oldMultiLeaderboardPanel.add((Widget)multiLeaderboardPanel);
    }

    public void updatedMultiLeaderboard(LeaderboardDTO leaderboard, boolean hasLiveRace) {
        if (leaderboard != null) {
            String comment = leaderboard.getComment() != null ? leaderboard.getComment() : "";
            String scoringScheme = leaderboard.scoringScheme != null ? ScoringSchemeTypeFormatter.getDescription((ScoringSchemeType)leaderboard.scoringScheme, (StringMessages)StringMessages.INSTANCE) : "";
            this.lastScoringCommentDiv.setInnerText(comment);
            this.scoringSchemeDiv.setInnerText(scoringScheme);
            if (this.delegate != null) {
                this.delegate.getLastScoringCommentElement().setInnerText(comment);
                this.delegate.getScoringSchemeElement().setInnerText(scoringScheme);
            }
            if (leaderboard.getTimePointOfLastCorrectionsValidity() != null) {
                Date lastCorrectionDate = leaderboard.getTimePointOfLastCorrectionsValidity();
                String lastUpdate = String.valueOf(DateAndTimeFormatterUtil.defaultDateFormatterUTC.render(lastCorrectionDate)) + ", " + DateAndTimeFormatterUtil.longTimeFormatterUTC.render(lastCorrectionDate);
                this.lastScoringUpdateTimeDiv.setInnerText(lastUpdate);
                this.lastScoringUpdateTextDiv.setInnerText(StringMessages.INSTANCE.eventRegattaLeaderboardLastScoreUpdate());
                if (this.delegate != null) {
                    this.delegate.getLastScoringUpdateTimeElement().setInnerText(lastUpdate);
                    this.delegate.getLastScoringUpdateTextElement().setInnerText(StringMessages.INSTANCE.eventRegattaLeaderboardLastScoreUpdate());
                }
            } else {
                this.lastScoringUpdateTimeDiv.setInnerText("");
                this.lastScoringUpdateTextDiv.setInnerText("");
            }
            Style.Visibility lastScoringUpdateTimeVisibility = !hasLiveRace ? Style.Visibility.VISIBLE : Style.Visibility.HIDDEN;
            this.lastScoringUpdateTimeDiv.getStyle().setVisibility(lastScoringUpdateTimeVisibility);
            if (this.delegate != null) {
                this.delegate.getLastScoringUpdateTimeElement().getStyle().setVisibility(lastScoringUpdateTimeVisibility);
            }
        }
    }

    public void onBusyStateChange(boolean busyState) {
        this.busyIndicator.setBusy(busyState);
        if (this.delegate != null) {
            this.delegate.setBusyState(busyState);
        }
    }

    public void onSelectedLeaderboardChanged(MultiRaceLeaderboardPanel selectedLeaderboard) {
        if (this.lastSelectedLeaderboardPanel != null) {
            this.lastSelectedLeaderboardPanel.removeBusyStateChangeListener((BusyStateChangeListener)this);
        }
        selectedLeaderboard.addBusyStateChangeListener((BusyStateChangeListener)this);
        this.lastSelectedLeaderboardPanel = selectedLeaderboard;
    }

    static /* synthetic */ MultiLeaderboardProxyPanel access$1(OldMultiLeaderboard oldMultiLeaderboard) {
        return oldMultiLeaderboard.multiLeaderboardPanel;
    }
}

